<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class ctAuth extends CI_Controller
{
    // Used for registering and changing password form validation
    var $min_username = 4;
    var $max_username = 20;
    var $min_password = 6;
    var $max_password = 15;

    function __construct()
    {
        parent::__construct();

        $this->load->library('Form_validation');
        $this->load->helper('form');
    }

    public function index()
    {
        
        if($this->dx_auth->is_max_login_attempts_exceeded()){
            $data['show_captcha'] = TRUE;
            $this->dx_auth->captcha();
        } else {
            $data['show_captcha'] = FALSE;
        }
        
		
        if (!$this->dx_auth->is_logged_in()) {
            $this->load->view('view_login_form',$data);
        } else {
            redirect('ctMain'); 
        }
        //$this->login();
    }

    function login()
    {
        //sleep(1);
		
        if (!$this->dx_auth->is_logged_in()) {
            $val = $this->form_validation;

            // Set form validation rules
            $val->set_rules('username', 'User ID', 'trim|required|xss_clean');
            $val->set_rules('password', 'Password', 'trim|required|xss_clean');


            if ($this->form_validation->run() === FALSE) {

                $data = array("error" => 1, "type" => "1", "msg" => "Please fill in all fields!",
                    "data" => form_errors_array()
                );

                echo json_encode($data);

            }
            else
            {

                if ($val->run() AND $this->dx_auth->login($val->set_value('username'), $val->set_value('password'))) {

                    $data['error'] = 0;
                    $data['type'] = 0;
                    $data['msg'] = "Login Success!";
                    //$this->session->set_userdata("sess_test","test");
                    //print_r($this->session->all_userdata());die();    
                    echo json_encode($data); die();
                }
                else
                {

                    // Check if the user is failed logged in because user is banned user or not
                    if ($this->dx_auth->is_banned()) {
                        $data['error'] = 1;
                        $data['type'] = 1;
                        $data['msg'] = "Your User ID is Banned! please Contact Administrator";
                        echo json_encode($data);
                    }
                    else if ($this->dx_auth->is_max_login_attempts_exceeded()) { // Show captcha if login attempts exceed max attempts in config
                        // Create catpcha
                        $this->dx_auth->captcha();
                        

                        // Set view data to show captcha on view file
                        $data['error'] = 1;
                        $data['type'] = 2;
                        $data['msg'] = "Max login attempt exceeded!";
                        $data['data']['captcha'] = TRUE;
                        $data['data']['image'] = $this->dx_auth->get_captcha_image();
                        //$this->dx_auth->_clear_login_attempts();
                        echo json_encode($data);

                    } else {
                        $data['error'] = 1;
                        $data['type'] = 1;
                        $data['msg'] = "Login failed, invalid User ID or Password";
                        echo json_encode($data);
                    }

                }
            }
        }
        else
        {
            $data['error'] = 1;
            $data['type'] = 1;
            $data['msg'] = 'You are already logged in. Please refresh this page';
            echo json_encode($data);
        }


    }

    function logout()
    {
        // Logout user
        $this->dx_auth->logout();
        redirect('');
    }

    function register()
    {
        // Register a user with username 'john', password 'johnpassword', and email 'john@yourmail.com'
        $i=100;
        while($i < 100){
           if ($user = $this->dx_auth->register('test'.$i, '123', 'test'.$i.'@yahoo.com')) {
                echo 'Welcome ' . $user->username;
            }
            else
            {
                echo 'Failed to register';
            } 
        $i++;
        }
        
    }


    function username_check($username)
    {
        $result = $this->dx_auth->is_username_available($username);
        if (!$result) {
            $this->form_validation->set_message('username_check', 'Username already exist. Please choose another username.');
        }

        return $result;
    }

    function email_check($email)
    {
        $result = $this->dx_auth->is_email_available($email);
        if (!$result) {
            $this->form_validation->set_message('email_check', 'Email is already used by another user. Please choose another email address.');
        }

        return $result;
    }

    function captchaCheck()
    {

        $val = $this->form_validation;
        $val->set_rules('captcha', 'Confirmation Code', 'trim|required|xss_clean');

        $code = $this->security->xss_clean($this->input->post('captcha'));

        if ($val->run() === FALSE) {

            $data = array("error" => 1, "type" => "1", "msg" => "Please fill in all fields!",
                "data" => form_errors_array()
            );

            $result =  json_encode($data);

        } elseif ($this->dx_auth->is_captcha_expired()) {
            $this->dx_auth->captcha();

            $data['error'] = 1;
            $data['type'] = 2;
            $data['msg'] = "Your confirmation code is expire. Try again.";
            $data['data']['captcha'] = TRUE;
            $data['data']['image'] = $this->dx_auth->get_captcha_image();
            $result = json_encode($data);
        }
        elseif (!$this->dx_auth->is_captcha_match($code))
        {
            $this->dx_auth->captcha();
            
            $data['error'] = 1;
            $data['type'] = 1;
            $data['data']['captcha'] = TRUE;
            $data['data']['image'] = $this->dx_auth->get_captcha_image();
            $data['msg'] = "Your confirmation code does not match the one in the image. Try again.";
            $result = json_encode($data);
        } else {
            $data['error'] = 0;
            $data['type'] = 0;
            $data['msg'] = "Captcha Match!.";
            $result = json_encode($data);
        }

        echo $result;
    }











    //for next dev
    function recaptcha_check()
    {
        $result = $this->dx_auth->is_recaptcha_match();
        if (!$result) {
            $this->form_validation->set_message('recaptcha_check', 'Your confirmation code does not match the one in the image. Try again.');
        }

        return $result;
    }

    /* End of Callback function */



    function register_recaptcha()
    {
        if (!$this->dx_auth->is_logged_in() AND $this->dx_auth->allow_registration) {
            $val = $this->form_validation;

            // Set form validation rules
            $val->set_rules('username', 'Username', 'trim|required|xss_clean|min_length[' . $this->min_username . ']|max_length[' . $this->max_username . ']|callback_username_check|alpha_dash');
            $val->set_rules('password', 'Password', 'trim|required|xss_clean|min_length[' . $this->min_password . ']|max_length[' . $this->max_password . ']|matches[confirm_password]');
            $val->set_rules('confirm_password', 'Confirm Password', 'trim|required|xss_clean');
            $val->set_rules('email', 'Email', 'trim|required|xss_clean|valid_email|callback_email_check');

            // Is registration using captcha
            if ($this->dx_auth->captcha_registration) {
                // Set recaptcha rules.
                // IMPORTANT: Do not change 'recaptcha_response_field' because it's used by reCAPTCHA API,
                // This is because the limitation of reCAPTCHA, not DX Auth library
                $val->set_rules('recaptcha_response_field', 'Confirmation Code', 'trim|xss_clean|required|callback_recaptcha_check');
            }

            // Run form validation and register user if it's pass the validation
            if ($val->run() AND $this->dx_auth->register($val->set_value('username'), $val->set_value('password'), $val->set_value('email'))) {
                // Set success message accordingly
                if ($this->dx_auth->email_activation) {
                    $data['auth_message'] = 'You have successfully registered. Check your email address to activate your account.';
                }
                else
                {
                    $data['auth_message'] = 'You have successfully registered. ' . anchor(site_url($this->dx_auth->login_uri), 'Login');
                }

                // Load registration success page
                $this->load->view($this->dx_auth->register_success_view, $data);
            }
            else
            {
                // Load registration page
                $this->load->view('auth/register_recaptcha_form');
            }
        }
        elseif (!$this->dx_auth->allow_registration)
        {
            $data['auth_message'] = 'Registration has been disabled.';
            $this->load->view($this->dx_auth->register_disabled_view, $data);
        }
        else
        {
            $data['auth_message'] = 'You have to logout first, before registering.';
            $this->load->view($this->dx_auth->logged_in_view, $data);
        }
    }
    
    function __getAllController(){  
        
        $controller = FCPATH . "application\\controllers\\";
                 
        //get all files in specified directory
        $files = glob($controller . "*");
         
        //print each file name
        foreach($files as $file)
        {
         //check to see if the file is a folder/directory
         if(is_dir($file))
         {
            $folder = $file;
            $handle = opendir($folder);     
            while (false !== ($file = readdir($handle))) {                  
             
                if(substr(strrchr($file,'.'),1) == "php"){                
                    $f_arr[] = substr($file,0,strlen($file)-4);
                }       
                 
            }
         }
        }
        
        
        //echo "<pre>";print_r($f_arr);
        
        return implode(",",$f_arr);
    }
    
    function setAllPermission(){            
        //usage = ctMain/setAllPermission//1 (root/setAllPermission/role_id)
        $role_id = $this->uri->segment(3);
        $ctl = $this->__getAllController();
        $this->load->model('dx_auth/permissions', 'permissions');
        $this->load->model("MDL_main", 'mdlMain');
        
        $check = $this->mdlMain->checkRoles($role_id);
        if($check == 0){
            echo 0; exit;
        }
        $ctr_arr = explode(",",$ctl);
        
        foreach($ctr_arr as $record){
             //$role_id = $this->session->userdata('DX_role_id');
             $permission_data = $this->permissions->get_permission_data($role_id);
        
             $permission_data[trim($record)] = "1";
             //echo $record;
            
             // Set permission data for role_id
             $this->permissions->set_permission_data($role_id, $permission_data);   
                
        }
        
        //echo "<pre>";
        //print_r($permission_data); die();
        echo 1;    
    }
	
	
}

/* End of file ctAuth.php */
/* Location: ./application/controllers/ctAuth.php */