<?php
class CT_inventory_control extends CI_Controller{
    function __construct()
    {
        parent::__construct();
		if (!$this->dx_auth->is_logged_in()) {
            redirect('');  
            die(); 
        }
        
        $uid = $this->session->userdata('DX_user_id');
        $username = $this->session->userdata('DX_username');
        
        if(!permissionAuth(2) && $uid != RID){ 
            header('HTTP/1.1 401 Unauthorize');die('noaccess');
        } 

		$this->load->model("inventory_control/mdl_inventory_control", 'mdl_inventory_control');
    }

    function index(){
         $this->load->view('inventory_control/view_fg');
    }    
    
	function in_finish_good(){
         $this->load->view('inventory_control/in_finish_good');
    }   
	function material_out(){
         $this->load->view('inventory_control/material_out');
    }   
	
	function material_loss(){
         $this->load->view('inventory_control/material_loss');
    }   
	function wire_loss(){
         $this->load->view('inventory_control/wire_loss');
    }   
	function wire_loss_mesin_rv(){
         $this->load->view('inventory_control/wire_loss_mesin_rv');
    }   
	function scrap_harnes_rework(){
         $this->load->view('inventory_control/scrap_harnes_rework');
    }   
	function scrap_harnes_project_training(){
         $this->load->view('inventory_control/scrap_harnes_project_training');
    }   
	function scrap_circuit_project_connector(){
         $this->load->view('inventory_control/scrap_circuit_project_connector');
    }   
	function scrap_material(){
         $this->load->view('inventory_control/scrap_material');
    }   
	function wip_produksi_harnes(){
         $this->load->view('inventory_control/wip_produksi_harnes');
    }   
	function wip_qa_checker(){
         $this->load->view('inventory_control/wip_qa_checker');
    }   
	function wip_unpull_pack(){
         $this->load->view('inventory_control/wip_unpull_pack');
    }   
	function wip_raw_material(){
         $this->load->view('inventory_control/wip_raw_material');
    }   
	function adjustment_stock(){
         $this->load->view('inventory_control/adjustment_stock');
    }   
	function wip_harnes_penumpukan(){
         $this->load->view('inventory_control/wip_harnes_penumpukan');
    }   
	function report(){
         $this->load->view('inventory_control/report');
    }  
	
	
	
	function view_inventory_control_upload(){
		
		$tipe = (isset($_POST['tipe']) && !empty($_POST['tipe']))?$_POST['tipe']:die('{"sts":"ERROR","desc":" Param  filename Tidak Ditemukan"}');
		$data['tipex'] = $tipe;
		$this->load->view('inventory_control/view_inventory_control_upload', $data);
	
	}
	
	
	function tbl_inventory_control(){
	
		$search = isset($_POST['_search'])?$_POST['_search']:false;
		$searchField = isset($_POST['searchField'])?$_POST['searchField']:'';
		$searchString = isset($_POST['searchString'])?$_POST['searchString']:'';
		$filters =  isset($_POST['filters'])?$_POST['filters']:'';
		
		$page = isset($_POST['page'])?$_POST['page']:1; // get the requested page
		$limit = isset($_POST['rows'])?$_POST['rows']:20; // get how many rows we want to have into the grid
		$sidx = isset($_POST['sidx'])?$_POST['sidx']:'tbl_inventory_control'; // get index row - i.e. user click to sort
		$sord = isset($_POST['sord'])?$_POST['sord']:'0'; // get the direction	
		
		$jenis = isset($_POST['jenis'])?$_POST['jenis']:die('{"sts":"ERROR","desc":" Param  tgawal Tidak Ditemukan"}');
		$where = " 1=1 and jenis='$jenis' ";
		
		if (isset($_POST['periode'])){
			$periode=$_POST['periode'];
			
			$where .= " and PERIODE  like '%$periode%' ";
		}
		
		if ($search == 'true'){
			if (!empty($filters)){
				$array = json_decode($filters);
				foreach($array->rules as $arr=>$k){
					
					if ( $k->field == "jenis" ) {
						$searchString = $k->data;
						$where .= " and jenis like  '%".$searchString."%'"; 
					} else if ( $k->field == "periode" ) {
						$searchString = $k->data;
						$where .= " and periode like  '%".$searchString."%'"; 
					} else if ( $k->field == "landed_cost" ) {
						$searchString = $k->data;
						$where .= " and landed_cost like  '%".$searchString."%'"; 
					} else if ( $k->field == "currency" ) {
						$searchString = $k->data;
						$where .= " and currency like  '%".$searchString."%'"; 
					} else if ( $k->field == "tgl" ) {
						$searchString = $k->data;
						$where .= " and convert(varchar(10),tgl, 126) like  '%".$searchString."%'"; 
					}
					
				}
			}
		}
		
		$jml = 0;
		
		$qry = $this->db->query("
			SELECT
			isnull(sum([amount]),0) as [jml]
		  FROM [dbo].[tbl_inventory_control]
			  
			  where  $where 
			  
			  
		");
		
		foreach ($qry->result() as $r){
			$jml = $r->jml;	
		}
		
		
		
		
		$start = $limit*$page - $limit;
		if ($start<0) $start=0;
		
		$records = $this->mdl_inventory_control->tbl_inventory_control_All($limit,$start,$sidx,$sord, $where);
		$count = $this->mdl_inventory_control->tbl_inventory_control_CountAll($where);
		if( $count > 0 ) { $total_pages = ceil($count/$limit); } else { $total_pages = 0; } 
		if ($page > $total_pages) $page=$total_pages;
		
		$responce->page = $page;
		$responce->total = $total_pages;
		$responce->records =  $count;
		$i=0;
		foreach($records as $r){
						
			$responce->rows[$i]['id_inventory_control']=$r->id_inventory_control; 
			$responce->rows[$i]['tgl']=$r->tgl; 
			$responce->rows[$i]['amount']=$r->amount;
			$responce->rows[$i]['jenis']=$r->jenis;
			$responce->rows[$i]['title']=$r->title;
			$responce->rows[$i]['periode']=$r->periode;
			
			$i++;
		}
		$responce->userdata['amount'] = $jml;
		echo json_encode($responce);		
	
	
	}
	
	
	function upload_inventory_control(){
	   $status = "";
	   $msg = "";
	   $file_element_name = 'userfile_inventory_control_upload';
	   //$username = $this->session->userdata('DX_user_id');
	   $username = $this->session->userdata('DX_username');
	   $tipe =  isset($_POST['tipe'])?$_POST['tipe']:die('{"sts":"ERROR","desc":" Param  tgawal Tidak Ditemukan"}');
		
	   if ($status != "error")
	   {
		  $apppath = $this->config->item('APP_upload_path');
		  $config['upload_path'] = $apppath."inventory_control/$tipe/";
		  $config['allowed_types'] = 'xls';
		  $config['max_size']  = 1024 * 100;
		  $config['encrypt_name'] = false;
		  $config['overwrite']=true;
		  $config['remove_spaces']=true;
		  $this->load->library('upload', $config);
		  if (!$this->upload->do_upload($file_element_name))
		  {
			 $status = 'error';
			 $msg = $this->upload->display_errors('', '');
		  }
		  else
		  {
			 $data = $this->upload->data();
			 
			  // print_r($data);
			  // die();
			 if($data)
			 {
				$myFile = $data['full_path']; 
				$newfile=$apppath."inventory_control/$tipe/log/".$data['file_name'];
				$filename=$data['file_name'];
				//echo $myFile; die();
				/* echo " exec('[spuload_stockawal_fg] @filepath=''$myFile'', @filename=''$filename'', @username=''$username'', @tipe=''$tipe'', @trx=''add'', @id=0 ')";
				die(); */
				 
				$qry = $this->db->query("
					BEGIN TRY
					
					 exec('[spuload_inventory_control] @filepath=''$myFile'', @filename=''$filename'', @username=''$username'', @tipe=''$tipe'', @trx=''add'', @id=0 ')
					
					END TRY
					BEGIN CATCH 
						SELECT 
						'error' AS status
						,ERROR_MESSAGE() AS description;
						
					END CATCH;
					
					");
				 
				 $rs = $qry->result_array();
				 // $r = $qry->result();		
				 // var_dump($r);die();
				 foreach ($rs as $row){
					 $status = $row['status'];
					 $msg = $row['description'];
				 }  
				//  echo json_encode($responce);
				 // $stmt = " exec('[spuload_stockawal_fg]') ";
				 // $qry = mssql_query($stmt); 
				 // $row = mssql_fetch_array($qry); 
				 // var_dump($row);die();
						 
				
				
				
				$status = $status;
				$msg = $msg;
			 }
			 else
			 {
				unlink($data['full_path']);
				$status = "error";
				$msg = "Something went wrong when saving the file, please try again.";
			 }
		  }
		  @unlink($_FILES[$file_element_name]);
	   }
	   echo json_encode(array('status' => $status, 'msg' => $msg));
		
	}
	
	function deletefile_inventory_control_upload(){
		$filename = (isset($_POST['filename']) && !empty($_POST['filename']))?$_POST['filename']:die('{"sts":"ERROR","desc":" Param Tidak Ditemukan"}');
		$tipe = (isset($_POST['tipe']) && !empty($_POST['tipe']))?$_POST['tipe']:die('{"sts":"ERROR","desc":" Param Tidak Ditemukan"}');
		$id = (isset($_POST['id']) && !empty($_POST['id']))?$_POST['id']:die('{"sts":"ERROR","desc":" Param Tidak Ditemukan"}');
		//$username = $this->session->userdata('DX_user_id');
	    $username = $this->session->userdata('DX_username');
		$apppath = $this->config->item('APP_upload_path');
		
		$path=$apppath."inventory_control/$tipe/".$filename;
		$pathnew=$apppath."inventory_control/$tipe/log/".$filename;
		
		if (!file_exists($path)) {
		   echo json_encode(array('sts' => '00', 'desc' => 'file does not exist'));
			die();
		}
		
		
		
		$qry = $this->db->query("
			BEGIN TRY
			
			 exec('[spuload_inventory_control] @filepath=''$path'', @filename=''$filename'', @username=''$username'', @tipe=''$tipe'', @trx=''delete'', @id=$id ')
			
			END TRY
			BEGIN CATCH 
				SELECT 
				'06' AS status
				,ERROR_MESSAGE() AS description;
				
			END CATCH;
			
			");
		 $rs = $qry->result_array();
		 // $r = $qry->result();		
		 // var_dump($r);die();
		 foreach ($rs as $row){
			 $status = $row['status'];
			 $msg = $row['description'];
		 }  
		
		$status = $status;
		$msg = $msg;
		
		if ($status=='00'){
			//copy($path, $pathnew) or die(array('sts' => '00','desc' => "Unable to copy $path to $pathnew."));
			if (file_exists($path)) {
				unlink($path);
			} else {
				echo json_encode(array('sts' => '00', 'desc' => 'file does not exist'));
				die();
			}
		}
		echo json_encode(array('sts' => $status, 'desc' => $msg));
	
	
	}
	
	function tbl_upload_inventory_control(){
		$search = isset($_POST['_search'])?$_POST['_search']:false;
        $searchField = isset($_POST['searchField'])?$_POST['searchField']:'';
        $searchString = isset($_POST['searchString'])?$_POST['searchString']:'';
        $filters =  isset($_POST['filters'])?$_POST['filters']:'';
		
		$page = isset($_POST['page'])?$_POST['page']:1; // get the requested page
        $limit = isset($_POST['rows'])?$_POST['rows']:20; // get how many rows we want to have into the grid
        $sidx = isset($_POST['sidx'])?$_POST['sidx']:'id_scrap_upload'; // get index row - i.e. user click to sort
        $sord = isset($_POST['sord'])?$_POST['sord']:'0'; // get the direction
		
		$tipe = isset($_POST['tipe'])?$_POST['tipe']:'id_upload_master';
		$where = " 1=1 and tipe='$tipe' ";
		
		if ($search == 'true'){
			if (!empty($filters)){
				$array = json_decode($filters);
				foreach($array->rules as $arr=>$k){
					
					if ( $k->field == "filename" ) {
						$searchString = $k->data;
						$where .= " and filename like  '%".$searchString."%'"; 
					} else if ( $k->field == "date_upload" ) {
						$searchString = $k->data;
						$where .= " and CONVERT(VARCHAR(10),[date_upload],103)  =  '$searchString'"; 
					} else if ( $k->field == "status_upload" ) {
						$searchString = $k->data;
						$where .= " and status_upload like  '%".$searchString."%'"; 
					}  else if ( $k->field == "create_by" ) {
						$searchString = $k->data;
						$where .= " and create_by like  '%".$searchString."%'"; 
					} 
				}
			}
		}
		
		$start = $limit*$page - $limit;
		if ($start<0) $start=0;
		
		$records = $this->mdl_inventory_control->tbl_upload_inventory_control_All($limit,$start,$sidx,$sord, $where);
        $count = $this->mdl_inventory_control->tbl_upload_inventory_control_CountAll($where);
		if( $count > 0 ) { $total_pages = ceil($count/$limit); } else { $total_pages = 0; } 
        if ($page > $total_pages) $page=$total_pages;
        
        $responce->page = $page;
		$responce->total = $total_pages;
		$responce->records =  $count;
		$i=0;
        foreach($records as $r){
						
			$responce->rows[$i]['id']=$r->id; 
			$responce->rows[$i]['date_upload']=$r->date_upload; 
			$responce->rows[$i]['filename']= $r->filename; 
			$responce->rows[$i]['filename2']=str_replace(".xls","", $r->filename); 
			
			$responce->rows[$i]['status_upload']=$r->status_upload;
			$responce->rows[$i]['create_date']=$r->create_date;
			$responce->rows[$i]['create_by']=$r->create_by;
			$responce->rows[$i]['tipe']=$r->tipe;
			$responce->rows[$i]['filepath']=$r->filepath;
			$responce->rows[$i]['update_date']=$r->update_date;
			$responce->rows[$i]['update_by']=$r->update_by;
		
			
			$i++;
		}
		echo json_encode($responce);	
	
	}
	
	
	function cek_data_inventory_control_upload(){
		error_reporting(E_ALL ^ E_NOTICE);
		//$this->load->file("application/libraries/excel_reader2.php", true);
		
		//require_once 'excel_reader2.php';
		//$this->load->library('Spreadsheet_Excel_Reader');
		include_once ( APPPATH."libraries/excel_reader2.php");
		
		$filename = (isset($_POST['filename']) && !empty($_POST['filename']))?$_POST['filename']:die('{"sts":"ERROR","desc":" Param Tidak Ditemukan"}');
		$tipe = (isset($_POST['tipe']) && !empty($_POST['tipe']))?$_POST['tipe']:die('{"sts":"ERROR","desc":" Param Tidak Ditemukan"}');
		$apppath = $this->config->item('APP_upload_path');
		$path=$apppath."inventory_control/$tipe/".$filename;
		$data = new Spreadsheet_Excel_Reader($path, false);
		
		echo $data->dump(true,true);
		
		
	}
	
	function proses_data_inventory_control_upload(){
		$filename = (isset($_POST['filename']) && !empty($_POST['filename']))?$_POST['filename']:die('{"sts":"ERROR","desc":" Param Tidak Ditemukan"}');
		$tipe = (isset($_POST['tipe']) && !empty($_POST['tipe']))?$_POST['tipe']:die('{"sts":"ERROR","desc":" Param Tidak Ditemukan"}');
		$id = (isset($_POST['id']) && !empty($_POST['id']))?$_POST['id']:die('{"sts":"ERROR","desc":" Param Tidak Ditemukan"}');
		//$username = $this->session->userdata('DX_user_id');
	    $username = $this->session->userdata('DX_username');
		$apppath = $this->config->item('APP_upload_path');
		
		$path=$apppath.'bb_added/koefisien/'.$filename;
		$pathnew=$apppath.'bb_added/koefisien/log/'.$filename;
		
		$typebahan = $tipe ;
		/* 
		echo  " 
			BEGIN TRY
			  exec('[spi_inventory_control] @filename=''$filename'', @id=$id, @tipe=''$tipe'',  @username=''$username'', @typebahan=''$typebahan''  ')
			END TRY
			BEGIN CATCH 
				SELECT 
				'error' AS status
				,ERROR_MESSAGE() AS description;
				
			END CATCH; 
		
		
		";
		die(); 
		*/
		
		$qry = $this->db->query("
			BEGIN TRY
			  exec('[spi_inventory_control] @filename=''$filename'', @id=$id, @tipe=''$tipe'',  @username=''$username'', @typebahan=''$typebahan''  ')
			END TRY
			BEGIN CATCH 
				SELECT 
				'error' AS status
				,ERROR_MESSAGE() AS description;
				
			END CATCH; 
			
			 ");
		 $rs = $qry->result_array();
         //// $r = $qry->result();		
		//// var_dump($r);die();
		 foreach ($rs as $row){
			 $responce = array("sts" => $row['status'], "desc" => $row['description'].' ');
		 }  
		 echo json_encode($responce);
			
		
	}
	
	function proses_delete_inventory_control(){
		$idx = (isset($_POST['id']) && !empty($_POST['id']))?$_POST['id']:die('{"sts":"ERROR","desc":" Param Tidak Ditemukan"}');
		
		$qry = $this->db->query("
			BEGIN TRY
				delete from tbl_inventory_control where [id_inventory_control] = $idx
			END TRY
			BEGIN CATCH 
				SELECT 
				'06' AS status
				,ERROR_MESSAGE() AS description;
				
			END CATCH;
			SELECT 
				'00' AS status
				,'DATA DELETED' AS description;
		");
		
		 $rs = $qry->result_array();
         //// $r = $qry->result();		
		//// var_dump($r);die();
		 foreach ($rs as $row){
			 $responce = array("sts" => $row['status'], "desc" => $row['description'].' ');
		 }  
		 echo json_encode($responce);
		
		
	}
	
	public function nama_bulan($angka){
		switch ($angka) {
			case 1:
				return "JAN";
				break;
			case 2:
				return "FEB";
				break;
			case 3:
				return "MAR";
				break;
			case 3:
				return "MAR";
				break;
			case 4:
				return "APR";
				break;
			case 5:
				return "MEI";
				break;
			case 6:
				return "JUN";
				break;
			case 7:
				return "JUL";
				break;
			case 8:
				return "AGS";
				break;
			case 9:
				return "SEP";
				break;
			case 10:
				return "OCT";
				break;
			case 11:
				return "NOV";
				break;
			case 12:
				return "DES";
				break;
							
			default:
				return $angka;
		}
		
	}
	
	function data_report(){
		$periode1 = (isset($_POST['periode1']) && !empty($_POST['periode1']))?$_POST['periode1']:die('{"sts":"ERROR","desc":" Param Tidak Ditemukan"}');
		$periode2 = (isset($_POST['periode2']) && !empty($_POST['periode2']))?$_POST['periode2']:die('{"sts":"ERROR","desc":" Param Tidak Ditemukan"}');
		$jmlbln = (int)abs((strtotime($periode1.'-01') - strtotime($periode2.'-01'))/(60*60*24*30)) + 1;
		
		$peri1 = str_replace('-','',$periode1);
		$peri2 = str_replace('-','',$periode2);
		$angkatgl1 = explode('-',$periode1);
		$angkatgl2 = explode('-',$periode2);
		$angkabln = $angkatgl1[1];
		$angkathn = $angkatgl1[0];
		$artgl = array();
		$artglbln = array();
		$i=0;
		$j = $angkathn;
		
		for ($x = 1; $x <= $jmlbln; $x++) {
			
			$k = $angkabln+$i;
			
			if ($k == 13){
				$k = 0;
				$i = 1;
				$angkabln = 0;
				$j = $j + 1;
			}	
			if ( $k== 0){$k=1;} 
			
			$artgl[] .= $this->nama_bulan($k).'-'.$j;
			
			$i++;
		}
		
		
		$angkabln = $angkatgl1[1];
		$angkathn = $angkatgl1[0];
		$i=0;
		$j = $angkathn;
		for ($x = 1; $x <= $jmlbln; $x++) {
			
			$k = $angkabln+$i;
			
			if ($k == 13){
				$k = 0;
				$i = 1;
				$angkabln = 0;
				$j = $j + 1;
			}	
			if ( $k== 0){$k=1;} 
			
			$artglbln[] .= $j.sprintf('%02d', $k);;
			
			$i++;
		}	
		
		
		$q = $this->db->query("
			SELECT [inventory_control_id]
			,[inventory_control_name]
			FROM [dbo].[tbl_inventory_control_tittle] 
		
		");
		
		$table = "<style>
#customers {
  font-family: 'Trebuchet MS', Arial, Helvetica, sans-serif;
  border-collapse: collapse;
  width: 100%;
}

#customers td, #customers th {
  border: 1px solid #ddd;
  padding: 8px;
}

#customers tr:nth-child(even){background-color: #f2f2f2;}

#customers tr:hover {background-color: #ddd;}

#customers th {
  padding-top: 12px;
  padding-bottom: 12px;
  text-align: left;
  background-color: #4CAF50;
  color: white;
}
</style>";
		
		$table .= "<table id='customers'> ";
		$table .= "
		 <tr>
			<th>ITEM</th>
		";
		
		foreach($artgl as $value){
		  $table .="<th>$value</th>";
		}
		$table .="</tr>";
		/* 
		$table2 = "";
		foreach($artglbln as $value){
		  $table2 .="<td>$value</td>";
		}
		 */
		foreach ($q->result() as $r){
			$table .="<tr>";
			$table .=	"<td>" . $r->inventory_control_name . "</td>";	
			
			if($r->inventory_control_id == 'in_finish_good'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'in_finish_good'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			} else if($r->inventory_control_id == 'material_loss'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'material_loss'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}  else if($r->inventory_control_id == 'material_out'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'material_out'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}  else if($r->inventory_control_id == 'scrap_circuit_project_connector'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'scrap_circuit_project_connector'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}  else if($r->inventory_control_id == 'scrap_harnes_project_training'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'scrap_harnes_project_training'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}  else if($r->inventory_control_id == 'scrap_harnes_rework'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'scrap_harnes_rework'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}   else if($r->inventory_control_id == 'scrap_material'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'scrap_material'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}   else if($r->inventory_control_id == 'wip_harnes_penumpukan'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'wip_harnes_penumpukan'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}    else if($r->inventory_control_id == 'wip_produksi_harnes'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'wip_produksi_harnes'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}    else if($r->inventory_control_id == 'wip_qa_checker'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'wip_qa_checker'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}  else if($r->inventory_control_id == 'wip_raw_material'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'wip_raw_material'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}  else if($r->inventory_control_id == 'wip_unpull_pack'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'wip_unpull_pack'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}  else if($r->inventory_control_id == 'wire_loss'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'wire_loss'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}  else if($r->inventory_control_id == 'wire_loss_mesin_rv'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'wire_loss_mesin_rv'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			} else {
				
				foreach($artglbln as $value){
					
					$table .="<td align='right'>$0.00</td>";
				}	
				
			}
			
			
				
			$table .= "</tr>";	
			
		}	
		
		
		$table .= "</table>";
		echo $table;		
		
	}
	
	
	function data_report_xls(){
		$periode1 = (isset($_GET['periode1']) && !empty($_GET['periode1']))?$_GET['periode1']:die('{"sts":"ERROR","desc":" Param Tidak Ditemukan"}');
		$periode2 = (isset($_GET['periode2']) && !empty($_GET['periode2']))?$_GET['periode2']:die('{"sts":"ERROR","desc":" Param Tidak Ditemukan"}');
		$jmlbln = (int)abs((strtotime($periode1.'-01') - strtotime($periode2.'-01'))/(60*60*24*30)) + 1;
		
		$peri1 = str_replace('-','',$periode1);
		$peri2 = str_replace('-','',$periode2);
		$angkatgl1 = explode('-',$periode1);
		$angkatgl2 = explode('-',$periode2);
		$angkabln = $angkatgl1[1];
		$angkathn = $angkatgl1[0];
		$artgl = array();
		$artglbln = array();
		$i=0;
		$j = $angkathn;
		
		for ($x = 1; $x <= $jmlbln; $x++) {
			
			$k = $angkabln+$i;
			
			if ($k == 13){
				$k = 0;
				$i = 1;
				$angkabln = 0;
				$j = $j + 1;
			}	
			if ( $k== 0){$k=1;} 
			
			$artgl[] .= $this->nama_bulan($k).'-'.$j;
			
			$i++;
		}
		
		
		$angkabln = $angkatgl1[1];
		$angkathn = $angkatgl1[0];
		$i=0;
		$j = $angkathn;
		for ($x = 1; $x <= $jmlbln; $x++) {
			
			$k = $angkabln+$i;
			
			if ($k == 13){
				$k = 0;
				$i = 1;
				$angkabln = 0;
				$j = $j + 1;
			}	
			if ( $k== 0){$k=1;} 
			
			$artglbln[] .= $j.sprintf('%02d', $k);;
			
			$i++;
		}	
		
		
		$q = $this->db->query("
			SELECT [inventory_control_id]
			,[inventory_control_name]
			FROM [dbo].[tbl_inventory_control_tittle] 
		
		");
		
		$table = "<style>
#customers {
  font-family: 'Trebuchet MS', Arial, Helvetica, sans-serif;
  border-collapse: collapse;
  width: 100%;
}

#customers td, #customers th {
  border: 1px solid #ddd;
  padding: 8px;
}

#customers tr:nth-child(even){background-color: #f2f2f2;}

#customers tr:hover {background-color: #ddd;}

#customers th {
  padding-top: 12px;
  padding-bottom: 12px;
  text-align: left;
  background-color: #4CAF50;
  color: white;
}
</style>";
		
		$table .= "<table id='customers'> ";
		$table .= "
		 <tr>
			<th>ITEM</th>
		";
		
		foreach($artgl as $value){
		  $table .="<th>$value</th>";
		}
		$table .="</tr>";
		/* 
		$table2 = "";
		foreach($artglbln as $value){
		  $table2 .="<td>$value</td>";
		}
		 */
		foreach ($q->result() as $r){
			$table .="<tr>";
			$table .=	"<td>" . $r->inventory_control_name . "</td>";	
			
			if($r->inventory_control_id == 'in_finish_good'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'in_finish_good'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			} else if($r->inventory_control_id == 'material_loss'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'material_loss'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}  else if($r->inventory_control_id == 'material_out'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'material_out'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}  else if($r->inventory_control_id == 'scrap_circuit_project_connector'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'scrap_circuit_project_connector'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}  else if($r->inventory_control_id == 'scrap_harnes_project_training'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'scrap_harnes_project_training'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}  else if($r->inventory_control_id == 'scrap_harnes_rework'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'scrap_harnes_rework'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}   else if($r->inventory_control_id == 'scrap_material'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'scrap_material'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}   else if($r->inventory_control_id == 'wip_harnes_penumpukan'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'wip_harnes_penumpukan'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}    else if($r->inventory_control_id == 'wip_produksi_harnes'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'wip_produksi_harnes'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}    else if($r->inventory_control_id == 'wip_qa_checker'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'wip_qa_checker'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}  else if($r->inventory_control_id == 'wip_raw_material'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'wip_raw_material'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}  else if($r->inventory_control_id == 'wip_unpull_pack'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'wip_unpull_pack'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}  else if($r->inventory_control_id == 'wire_loss'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'wire_loss'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			}  else if($r->inventory_control_id == 'wire_loss_mesin_rv'){
				foreach($artglbln as $value){
					$q = $this->db->query("
					select
						isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$value' and [jenis] = 'wire_loss_mesin_rv'
					
					");
					$amt = 0;
					foreach($q->result() as $r){
						$amt = $r->amt;		
					}
					$table .="<td align='right'>$amt</td>";
				}	
				
			} else {
				
				foreach($artglbln as $value){
					
					$table .="<td align='right'>$0.00</td>";
				}	
				
			}
			
			
				
			$table .= "</tr>";	
			
		}	
		
		
		$table .= "</table>";
		
		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="myfile.xls"');
		header('Cache-Control: max-age=0');
		echo $table;
		
		
		
		
	}
	
	
	function data_report_xls2(){
		$periode1 = (isset($_GET['periode1']) && !empty($_GET['periode1']))?$_GET['periode1']:die('{"sts":"ERROR","desc":" Param Tidak Ditemukan"}');
		$periode2 = (isset($_GET['periode2']) && !empty($_GET['periode2']))?$_GET['periode2']:die('{"sts":"ERROR","desc":" Param Tidak Ditemukan"}');
		$jmlbln = (int)abs((strtotime($periode1.'-01') - strtotime($periode2.'-01'))/(60*60*24*30)) + 1;
		
		$peri1 = str_replace('-','',$periode1);
		$peri2 = str_replace('-','',$periode2);
		$angkatgl1 = explode('-',$periode1);
		$angkatgl2 = explode('-',$periode2);
		$angkabln = $angkatgl1[1];
		$angkathn = $angkatgl1[0];
		$artgl = array();
		$artglbln = array();
		$i=0;
		$j = $angkathn;
		
		for ($x = 1; $x <= $jmlbln; $x++) {
			
			$k = $angkabln+$i;
			
			if ($k == 13){
				$k = 0;
				$i = 1;
				$angkabln = 0;
				$j = $j + 1;
			}	
			if ( $k== 0){$k=1;} 
			
			$artgl[] .= $this->nama_bulan($k).'-'.$j;
			
			$i++;
		}
		
		
		$angkabln = $angkatgl1[1];
		$angkathn = $angkatgl1[0];
		$i=0;
		$j = $angkathn;
		for ($x = 1; $x <= $jmlbln; $x++) {
			
			$k = $angkabln+$i;
			
			if ($k == 13){
				$k = 0;
				$i = 1;
				$angkabln = 0;
				$j = $j + 1;
			}	
			if ( $k== 0){$k=1;} 
			
			$artglbln[] .= $j.sprintf('%02d', $k);;
			
			$i++;
		}	
		
		
		$q = $this->db->query("
			SELECT [inventory_control_id]
			,[inventory_control_name]
			FROM [dbo].[tbl_inventory_control_tittle] 
		
		");
		
		include_once ( APPPATH."libraries/PHPExcel.php");	
		include_once ( APPPATH."libraries/PHPExcel/IOFactory.php");	
		$phpExcel = new PHPExcel();
		$phpExcel->setActiveSheetIndex(0);
		$phpExcel->getActiveSheet()->setTitle('INVENTORY CONTROL');
		$phpExcel->getActiveSheet()->setCellValueExplicit("A" . "1", "ITEM" , PHPExcel_Cell_DataType::TYPE_STRING); 
		$phpExcel
			->getActiveSheet()
			->getStyle("A" . "1")
			->getFill()
			->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
			->getStartColor()
			->setRGB('CCFFFF'); //i.e,colorcode=D3D3D3
		$phpExcel->getActiveSheet()->getColumnDimension('A')->setWidth(40);
		$i = 2;
		foreach ($q->result() as $r){
					
			$phpExcel->getActiveSheet()->setCellValueExplicit("A" . "$i", $r->inventory_control_name , PHPExcel_Cell_DataType::TYPE_STRING); 
			$i++;
		}	
		$j = $i+0;
		$phpExcel->getActiveSheet()->setCellValueExplicit("A" . "$j", "GRAND TOTAL" , PHPExcel_Cell_DataType::TYPE_STRING); 
		
		
		$a = count($artgl);
		$letter = "B";
		$arrletter = array();
		for ($x = 1; $x <= $a; $x++) {
			
			$phpExcel->getActiveSheet()->SetCellValue("$letter" . "1",  $artgl[$x-1] );
			
			$phpExcel
			->getActiveSheet()
			->getStyle("$letter" . "1")
			->getFill()
			->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
			->getStartColor()
			->setRGB('00CC66'); //i.e,colorcode=D3D3D3
			
			$letter++;
		}	
		
		
		$i = 2;
		foreach ($q->result() as $r){
			$letter = "B";
			for ($x = 1; $x <= $a; $x++) {
					$periode = 	$artglbln[$x-1];	
					$jenis_inv =  $r->inventory_control_id;
					
					$qq= $this->db->query("
						select
							isnull(sum(amount), 0) as amt
						FROM [dbo].[tbl_inventory_control]
						where [periode] = '$periode' and [jenis] = '$jenis_inv'
					
					");
					$amt = 0;
					foreach($qq->result() as $rr){
						$amt = $rr->amt;	
					}
				$phpExcel->getActiveSheet()->SetCellValue("$letter" . "$i",  $amt);	
				$phpExcel->getActiveSheet()->getStyle("$letter"."$i")->getNumberFormat()->setFormatCode('#,##0.00');		
				$letter++;
			}	
			
			$i++;	
		}
		
		
		//die();
		
		
		$filename = 'inventory_control.xls';
		header("Content-type:application/vnd.ms-excel");
		header("Content-disposition:attachment; filename=$filename"); 
		header("Pragma:no-cache");
		header("Cache-Control:must-revalidate, post-check=0, pre-check=0");
		header("Expires:0");

		$objWriter = PHPExcel_IOFactory::createWriter($phpExcel, 'Excel5');  //downloadable file is in Excel 2003 format (.xls)
		$objWriter->save('php://output');  //send it to user, of course you can save it to disk also!
		 
		exit; //done.. exiting!	
		
		
	}
		
	
	
	
    
	
}