<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class ct_pasi_auth_load extends CI_Controller
{
    // Used for registering and changing password form validation
    var $min_username = 4;
    var $max_username = 20;
    var $min_password = 6;
    var $max_password = 15;

    function __construct()
    {
        parent::__construct();

        $this->load->library('Form_validation');
        $this->load->helper('form');
    }

    public function index()
    {
        
        if($this->dx_auth->is_max_login_attempts_exceeded()){
            $data['show_captcha'] = TRUE;
            $this->dx_auth->captcha();
        } else {
            $data['show_captcha'] = FALSE;
        }
        
		
        if (!$this->dx_auth->is_logged_in()) {
            $this->load->view('view_login_form',$data);
        } else {
            redirect('ctMain'); 
        }
        //$this->login();
    }


    function login()
    {
        //sleep(1);
        $val = $this->form_validation;

        // Set form validation rules
        $val->set_rules('username', 'User ID', 'trim|required|xss_clean');
        $val->set_rules('password', 'Password', 'trim|required|xss_clean');

     

                if ($val->run() AND $this->dx_auth->login($val->set_value('username'), $val->set_value('password'))) {

                    $data['error'] = 0;
                    $data['type'] = 0;
                    $data['msg'] = "Login Success!";
                    //$this->session->set_userdata("sess_test","test");
                    //print_r($this->session->all_userdata());die();    
                    echo json_encode($data); die();
                }
                else
                {

 
                        $data['error'] = 1;
                        $data['type'] = 1;
                        $data['msg'] = "Login failed, invalid User ID or Password";
                        echo json_encode($data);
                    

                }
  

    }

}

?>