
SET QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
CREATE FUNCTION dbo.fn_rpt_out_bc30( 
  @start_date date
, @end_date date
, @source varchar(255) = 'ALL'
) 

RETURNS  @rpt_out_bc30 TABLE (
 id bigint identity(1,1) 
 , data_source varchar(255) 
 , NOMOR_AJU varchar(255)
 , NOMOR_DAFTAR varchar(255)
 , TANGGAL_DAFTAR date
 , KODE_DOKUMEN_PABEAN varchar(255)
 , TANGGAL_KELUAR date
 , SERI_BARANG int
 , KODE_BARANG varchar(255)
 , URAIAN varchar(255)
 , JUMLAH_SATUAN decimal(38,4)
 , KODE_SATUAN varchar(255)
 , JUMLAH_KEMASAN decimal(38,4)
 , BRUTO decimal(38,4)
 , CIF decimal(38,2)
 , KPBC varchar(255)
 , CIF_DETAIL decimal(38,2)
 , NDPBM decimal(38,4)
 , CIF_RUPIAH decimal(38,2)
 , POS_TARIF varchar(255)
 , NOMOR_INVOICE varchar(255)
 --, TANGGAL_INVOICE date
 , TANGGAL_INVOICE varchar(255)
 , AMOUNT_INVOICE decimal(38,4)
 , NOMOR_BL varchar(255)
 , TANGGAL_BL date
 , TARIF_BM decimal(38,2)
 , NAMA_PENERIMA varchar(255)
 , NAMA_ANGKUT varchar(255)
 , NOMOR_KONTAINER varchar(255)
 , UKURAN_KONTAINER varchar(255)
  )  
WITH EXECUTE AS CALLER 
AS
BEGIN   

if (@source = 'WH' OR @source = 'All')
 begin
  ;WITH
cte_hdr (
 urut,
 id_bc_out_hdr,
 NOMOR_AJU,
 NOMOR_DAFTAR,
 TANGGAL_DAFTAR,
 TANGGAL_KELUAR, 
 SERI_BARANG,
 KODE_BARANG,
 URAIAN,
 JUMLAH_SATUAN,
 KODE_SATUAN,
 CIF,
 POS_TARIF,
 TARIF_BM,
 JUMLAH_KEMASAN,
 TYPEDOk,
 BRUTO,
 KPBC,
 NDPBM,
 NAMA_PENERIMA,
 NAMA_ANGKUT,
 NOSHIPORD,
 TGSHIPORD,
 NILINV
) as (
SELECT
 ROW_NUMBER() OVER (PARTITION BY a.tableid, a.id_bc_out_hdr ORDER BY a.tableid, a.id_bc_out_hdr),
 a.id_bc_out_hdr ,a.car, a.NODAFT, a.TGDAFT, a.doc_out_date, a.SERIBRG, a.KDBRG, a.URAIAN, a.JMSATUAN, a.JNSATUAN, a.DnilInv, a.HS, a.TARIF_BM,a.JMKOLI, a.typedok
 ,a.bruto, a.kdkpbc, a.ndpbm, a.namabeli, a.carrier, a.noshipord, a.tgshipord, a.NilInv
 from (Select 1 as tableid
 , a.id_bc_out_hdr
 , a.car
 , a.NODAFT
 , a.TGDAFT
 , a.doc_out_date
 , a.SERIBRG
 , a.KDBRG
 , a.[uraian] as URAIAN
 , a.JMSATUAN
 , a.JNSATUAN
 , a.DnilInv 
 , a.HS
 , 5 as TARIF_BM
 , a.JMKOLI
 , a.typedok
 , a.bruto
 , a.kdkpbc
 , a.ndpbm
 , a.namabeli
 , a.carrier
  ,a.noshipord
  , a.tgshipord
  , a.NilInv

  from [v_bc3025_dtl] a
  where a.NODAFT is not null AND a.TGDAFT is not null
  AND (a.TGDAFT BETWEEN @start_date AND @end_date)
  
 ) a
)
,
ct_sumary_detail (
 urut,
 id_bc_out_hdr,
 JUMLAH_KEMASAN,
 CIF
) as (
 SELECT
 ROW_NUMBER() OVER (PARTITION BY a.id_bc_out_hdr ORDER BY a.id_bc_out_hdr),
 a.id_bc_out_hdr
 , sum(isnull(JMKOLI,0)) as KemasJm
 , sum(isnull(DNilInv,0)) as CIF
 FROM tbl_bc_out_dtl a 
 Left Join tbl_bc_out_hdr b ON a.id_bc_out_hdr = b.id_bc_out_hdr
 Left Join tbl_data_out_hdr c ON b.id_bc_out_hdr = c.id_terkait
 where b.NODAFT is not null AND b.TGDAFT is not null
  AND (b.TGDAFT BETWEEN @start_date AND @end_date)
  AND b.typedok = 'BC30'
 GROUP BY a.id_bc_out_hdr
)
,
ct_sumary_header (
 urut,
 id_bc_out_hdr,
 BRUTO,
 CIF,
 KPBC,
 NDPBM,
 NAMA_PENERIMA,
 NAMA_ANGKUT,
 NOMOR_DOKUMEN,
 TANGGAL_DOKUMEN
) as (
 SELECT
 ROW_NUMBER() OVER (PARTITION BY a.id_bc_out_hdr ORDER BY a.id_bc_out_hdr),
 id_bc_out_hdr
 , bruto
 , NilInv
 , b.UrKdKpbc
 , dbo.get_rate_valuta(a.TGDAFT,a.KdVal)
 , a.NAMABELI
 , a.CARRIER
 , a.NOSHIPORD
 , a.TGSHIPORD
 FROM tbl_bc_out_hdr a
 Left Join tblKpbc b ON a.KDKTRMUAT = b.KdKpbc
 where a.NODAFT is not null AND a.TGDAFT is not null
  AND (a.TGDAFT BETWEEN @start_date AND @end_date)
  AND a.typedok = 'BC30'
)
,
ct_invoice (
 urut,
 id_bc_out_hdr,
 NOMOR_DOKUMEN,
 TANGGAL_DOKUMEN,
 AMOUNT_INVOICE
) as (
 SELECT
 ROW_NUMBER() OVER (PARTITION BY a.id_bc_out_hdr ORDER BY a.id_bc_out_hdr),
 a.id_bc_out_hdr
 , NoDok
 , TgDok
 , c.NilInv
 FROM tbl_bc_out_dok a
 Left Join tbl_bc_out_hdr b ON a.id_bc_out_hdr = b.id_bc_out_hdr
 Left Join tblPebHdr c ON a.NoDok = c.NOINV AND a.TgDok = c.TGINV
 Where a.KdDok = '380'

 AND b.NODAFT is not null AND b.TGDAFT is not null
  AND (b.TGDAFT BETWEEN @start_date AND @end_date)
  AND b.typedok = 'BC30'
)
,
ct_dok (
 --urut,
 id_bc_out_hdr,
 NOMOR_DOKUMEN,
 TANGGAL_DOKUMEN
) as (
 SELECT DISTINCT ST2.id_bc_out_hdr, 
    SUBSTRING(
     (
      SELECT '#'+ST1.NoDok  AS [text()]
      FROM  tbl_bc_out_dok ST1
      WHERE ST1.id_bc_out_hdr = ST2.id_bc_out_hdr
      and KdDok = '380'
      ORDER BY ST1.id_bc_out_hdr
      FOR XML PATH ('')
     ), 3, 1000) [dokumen]
     , 
    SUBSTRING(
     (
      SELECT '#'+ convert(varchar(10),ST1.TgDok, 126)  AS [text()]
      FROM  tbl_bc_out_dok ST1
      WHERE ST1.id_bc_out_hdr = ST2.id_bc_out_hdr
      and KdDok = '380'
      ORDER BY ST1.id_bc_out_hdr
      FOR XML PATH ('')
     ), 2, 1000) [tgldokumen]
   FROM tbl_bc_out_dok ST2
   left outer join cte_hdr a on  ST2.id_bc_out_hdr = a.id_bc_out_hdr
),
ct_cont (
 --urut,
 id_bc_out_hdr,
 NOMOR_KONTAINER,
 UKURAN_KONTAINER
) as (
 SELECT DISTINCT ST2.id_bc_out_hdr, 
    SUBSTRING(
     (
      SELECT '#'+ST1.NoCont  AS [text()]
      FROM  tbl_bc_out_con ST1
      WHERE ST1.id_bc_out_hdr = ST2.id_bc_out_hdr
      ORDER BY ST1.id_bc_out_hdr
      FOR XML PATH ('')
     ), 2, 1000) [nocont]
     ,
    SUBSTRING(
     (
      SELECT '#'+ST1.[Size]  AS [text()]
      FROM  tbl_bc_out_con ST1
      WHERE ST1.id_bc_out_hdr = ST2.id_bc_out_hdr
      ORDER BY ST1.id_bc_out_hdr
      FOR XML PATH ('')
     ), 2, 1000) [noSize]
     
   FROM tbl_bc_out_con ST2
   left outer join cte_hdr a on  ST2.id_bc_out_hdr = a.id_bc_out_hdr
)

insert into @rpt_out_bc30 (data_source
, NOMOR_AJU
, NOMOR_DAFTAR
, TANGGAL_DAFTAR
, KODE_DOKUMEN_PABEAN
, TANGGAL_KELUAR
, SERI_BARANG
, KODE_BARANG
, URAIAN
, JUMLAH_SATUAN
, KODE_SATUAN
, JUMLAH_KEMASAN
, BRUTO
, CIF
, KPBC
, CIF_DETAIL
, POS_TARIF
, NOMOR_INVOICE
, TANGGAL_INVOICE
, NOMOR_BL
, TANGGAL_BL
, NDPBM
, CIF_RUPIAH
, TARIF_BM
, NAMA_PENERIMA
, NAMA_ANGKUT
, NOMOR_KONTAINER
, UKURAN_KONTAINER
, AMOUNT_INVOICE)
SELECT 'WH' 
, a.NOMOR_AJU
, a.NOMOR_DAFTAR
, a.TANGGAL_DAFTAR
, a.TYPEDOk
, a.TANGGAL_KELUAR
, a.SERI_BARANG
, a.KODE_BARANG
, a.URAIAN
, a.JUMLAH_SATUAN
, a.KODE_SATUAN
, a.JUMLAH_KEMASAN
, a.BRUTO
, a.CIF
, a.KPBC
, a.CIF
, a.POS_TARIF
, c.NOMOR_DOKUMEN
, c.TANGGAL_DOKUMEN
, a.NOSHIPORD
, a.TGSHIPORD
, a.NDPBM
, a.CIF * g.NDPBM
, a.TARIF_BM
, a.NAMA_PENERIMA
, a.NAMA_ANGKUT
, f.NOMOR_KONTAINER
, f.UKURAN_KONTAINER
, a.NILINV --a.CIF
from cte_hdr a
LEFT JOIN ct_dok c ON a.id_bc_out_hdr = c.id_bc_out_hdr
LEFT JOIN ct_cont f ON a.id_bc_out_hdr = f.id_bc_out_hdr
LEFT JOIN ct_sumary_header g ON a.id_bc_out_hdr = g.id_bc_out_hdr AND g.urut = 1
ORDER BY a.NOMOR_AJU, a.SERI_BARANG


;WITH
  cte_hdr (
   urut,
   ID_HEADER,
   NOMOR_AJU,
   NOMOR_DAFTAR,
   TANGGAL_DAFTAR,
   KODE_DOKUMEN_PABEAN,
   TANGGAL_MASUK,
   SERI_BARANG,
   URAIAN,
   KODE_BARANG,
   JUMLAH_SATUAN,
   KODE_SATUAN,
   CIF,
   POS_TARIF,
   TARIF,
   JUMLAH_KEMASAN,
   KODE_KEMASAN
  ) as (
  SELECT
   ROW_NUMBER() OVER (PARTITION BY b.ID_HEADER ORDER BY b.ID_HEADER)
   , b.ID_HEADER 
   , b.NOMOR_AJU
   , b.NOMOR_DAFTAR
   , b.TANGGAL_DAFTAR
   , b.KODE_DOKUMEN_PABEAN 
   , '' tanggal_masuk
   , a.SERI_BARANG
   , a.URAIAN
   , a.KODE_BARANG
   , a.JUMLAH_SATUAN
   , a.KODE_SATUAN
   , a.CIF
   , a.POS_TARIF
   , isnull(c.TARIF,0)
   , a.JUMLAH_KEMASAN
   , a.KODE_KEMASAN
   from dt_ms_tpb_out_barang a
   Left Join dt_ms_tpb_out_header b ON a.ID_HEADER = b.ID_HEADER
   Left Join dt_ms_tpb_out_barang_tarif c ON b.ID_HEADER = c.ID_HEADER AND a.ID = c.ID_BARANG AND c.JENIS_TARIF = 'BM'
   Where b.NOMOR_DAFTAR is not null AND b.TANGGAL_DAFTAR is not null
    AND (b.TANGGAL_DAFTAR BETWEEN @start_date AND @end_date)
    AND b.KODE_DOKUMEN_PABEAN = '23'
  ),
  ct_sumary_detail (
   urut,
   ID_HEADER,
   CIF
  ) as (
   SELECT
   ROW_NUMBER() OVER (PARTITION BY a.ID_HEADER ORDER BY a.ID_HEADER),
   a.ID_HEADER
   , sum(isnull(a.CIF,0)) as CIF
   FROM dt_ms_tpb_out_barang a 
   Left Join dt_ms_tpb_out_header b ON a.ID_HEADER = b.ID_HEADER
   Where b.NOMOR_DAFTAR is not null AND b.TANGGAL_DAFTAR is not null
    AND (b.TANGGAL_DAFTAR BETWEEN @start_date AND @end_date)
    AND b.KODE_DOKUMEN_PABEAN = '23'
   GROUP BY a.ID_HEADER
  ),
  ct_sumary_header (
   urut,
   ID_HEADER,
   BRUTO,
   CIF,
   KPBC,
   NDPBM,
   NAMA_PENERIMA,
   NAMA_ANGKUT
  ) as (
   SELECT
   ROW_NUMBER() OVER (PARTITION BY a.ID_HEADER ORDER BY a.ID_HEADER),
   ID_HEADER
   , BRUTO
   , CIF
   , b.URAIAN_KANTOR
   , dbo.get_rate_valuta(a.TANGGAL_DAFTAR,a.KODE_VALUTA)
   , a.NAMA_PENERIMA_BARANG
   , a.NAMA_PENGANGKUT
   FROM dt_ms_tpb_out_header a
   Left Join referensi_kantor_pabean b ON a.KODE_KANTOR = b.KODE_KANTOR
   Where a.NOMOR_DAFTAR is not null AND a.TANGGAL_DAFTAR is not null
    AND (a.TANGGAL_DAFTAR BETWEEN @start_date AND @end_date)
    AND a.KODE_DOKUMEN_PABEAN = '30'
  ),
  ct_invoice (
   urut,
   ID_HEADER,
   NOMOR_DOKUMEN,
   TANGGAL_DOKUMEN,
   AMOUNT_INVOICE
  ) as (
   SELECT
   ROW_NUMBER() OVER (PARTITION BY a.ID_HEADER ORDER BY a.ID_HEADER),
   a.ID_HEADER
   , a.NOMOR_DOKUMEN
   , a.TANGGAL_DOKUMEN
   , sum(isnull(c.CIF,0))
   FROM dt_ms_tpb_out_dokumen a
   Left Join dt_ms_tpb_out_header b ON a.ID_HEADER = b.ID_HEADER
   Left Join dt_ms_tpb_out_barang c ON a.ID_HEADER = c.ID_HEADER AND a.NOMOR_DOKUMEN = c.invoice_no AND a.TANGGAL_DOKUMEN = c.invoice_date
   Where a.KODE_JENIS_DOKUMEN = '380'

   AND b.NOMOR_DAFTAR is not null AND b.TANGGAL_DAFTAR is not null
    AND (b.TANGGAL_DAFTAR BETWEEN @start_date AND @end_date)
    AND b.KODE_DOKUMEN_PABEAN = '30'
   group by a.ID_HEADER
   , a.NOMOR_DOKUMEN
   , a.TANGGAL_DOKUMEN
  ),
  ct_bl (
   urut,
   ID_HEADER,
   NOMOR_DOKUMEN,
   TANGGAL_DOKUMEN
  ) as (
   SELECT
   ROW_NUMBER() OVER (PARTITION BY a.ID_HEADER ORDER BY a.ID_HEADER),
   a.ID_HEADER
   , NOMOR_DOKUMEN
   , TANGGAL_DOKUMEN
   FROM dt_ms_tpb_out_dokumen a
   Left Join dt_ms_tpb_out_header b ON a.ID_HEADER = b.ID_HEADER
   Where a.KODE_JENIS_DOKUMEN IN ('705', '740')

   AND b.NOMOR_DAFTAR is not null AND b.TANGGAL_DAFTAR is not null
    AND (b.TANGGAL_DAFTAR BETWEEN @start_date AND @end_date)
    AND b.KODE_DOKUMEN_PABEAN = '30'
  ),
  ct_bm (
   urut,
   ID_HEADER,
   BM,
   PPN,
   PPH
  ) as (
   SELECT
   ROW_NUMBER() OVER (PARTITION BY a.ID_HEADER ORDER BY a.ID_HEADER),
   a.ID_HEADER
   , sum((b.ndpbm * a.CIF) * (c.TARIF / 100))
   , sum(((b.ndpbm * a.CIF) * (1 + (c.TARIF / 100))) * (10/100))
   , sum(((b.ndpbm * a.CIF) * (1 + (c.TARIF / 100))) * (2.5/100))
   FROM dt_ms_tpb_out_barang a 
   Left Join ct_sumary_header b ON a.ID_HEADER = b.ID_HEADER
   LEFT JOIN dt_ms_tpb_out_barang_tarif c ON a.ID_HEADER = c.ID_HEADER AND a.ID = c.ID_BARANG 
   Left Join dt_ms_tpb_out_header d ON a.ID_HEADER = d.ID_HEADER
   Where d.NOMOR_DAFTAR is not null AND d.TANGGAL_DAFTAR is not null
    AND (d.TANGGAL_DAFTAR BETWEEN @start_date AND @end_date)
    AND d.KODE_DOKUMEN_PABEAN = '30'
   group by a.ID_HEADER
  ),
  ct_cont (
   urut,
   ID_HEADER,
   NOMOR_KONTAINER,
   KODE_UKURAN_KONTAINER
  ) as (
   SELECT
   ROW_NUMBER() OVER (PARTITION BY a.ID_HEADER ORDER BY a.ID_HEADER),
   a.ID_HEADER
   , a.NOMOR_KONTAINER
   , a.KODE_UKURAN_KONTAINER
   FROM dt_ms_tpb_out_kontainer a
   Left Join dt_ms_tpb_out_header b ON a.ID_HEADER = b.ID_HEADER
   Where b.NOMOR_DAFTAR is not null AND b.TANGGAL_DAFTAR is not null
    AND (b.TANGGAL_DAFTAR BETWEEN @start_date AND @end_date)
    AND b.KODE_DOKUMEN_PABEAN = '30'
  )


 insert into @rpt_out_bc30 (data_source
 , NOMOR_AJU
 , NOMOR_DAFTAR
 , TANGGAL_DAFTAR
 , KODE_DOKUMEN_PABEAN
 , TANGGAL_KELUAR
 , SERI_BARANG
 , URAIAN
 , KODE_BARANG
 , JUMLAH_SATUAN
 , KODE_SATUAN
 , JUMLAH_KEMASAN
 , BRUTO
 , CIF
 , KPBC
 , CIF_DETAIL
 , POS_TARIF
 , NOMOR_INVOICE
 , TANGGAL_INVOICE
 , NOMOR_BL
 , TANGGAL_BL
 , NDPBM
 , CIF_RUPIAH
 , TARIF_BM
 , NAMA_PENERIMA
 , NAMA_ANGKUT
 , NOMOR_KONTAINER
 , UKURAN_KONTAINER
 , AMOUNT_INVOICE)
 SELECT 'WH' 
 , a.NOMOR_AJU
 , a.NOMOR_DAFTAR
 , a.TANGGAL_DAFTAR
 , a.KODE_DOKUMEN_PABEAN
 , a.TANGGAL_MASUK
 , a.SERI_BARANG
 , a.URAIAN
 , a.KODE_BARANG
 , a.JUMLAH_SATUAN
 , a.KODE_SATUAN
 , a.JUMLAH_KEMASAN
 , c.BRUTO
 , b.CIF
 , c.KPBC
 , a.CIF
 , a.POS_TARIF
 , d.NOMOR_DOKUMEN
 , d.TANGGAL_DOKUMEN
 , e.NOMOR_DOKUMEN
 , e.TANGGAL_DOKUMEN
 , c.NDPBM
 , b.CIF * c.NDPBM
 , a.TARIF
 , c.NAMA_PENERIMA
 , c.NAMA_ANGKUT
 , g.NOMOR_KONTAINER
 , g.KODE_UKURAN_KONTAINER
 , d.AMOUNT_INVOICE
 from cte_hdr a
 LEFT JOIN ct_sumary_detail b ON a.ID_HEADER = b.ID_HEADER AND a.urut = b.urut
 LEFT JOIN ct_sumary_header c ON a.ID_HEADER = c.ID_HEADER AND a.urut = c.urut
 LEFT JOIN ct_invoice d ON a.ID_HEADER = d.ID_HEADER AND a.urut = d.urut
 LEFT JOIN ct_bl e ON a.ID_HEADER = e.ID_HEADER AND a.urut = e.urut
 LEFT JOIN ct_bm f ON a.ID_HEADER = f.ID_HEADER AND a.urut = f.urut
 LEFT JOIN ct_cont g ON a.ID_HEADER = g.ID_HEADER AND a.urut = g.urut
 ORDER BY a.NOMOR_AJU, a.SERI_BARANG

 end
 
 if(@source = 'AW' OR @source = 'All')
  begin
   ;WITH
cte_hdr (
 urut,
 id_bc_out_hdr,
 NOMOR_AJU,
 NOMOR_DAFTAR,
 TANGGAL_DAFTAR,
 TANGGAL_KELUAR, 
 SERI_BARANG,
 KODE_BARANG,
 URAIAN,
 JUMLAH_SATUAN,
 KODE_SATUAN,
 CIF,
 POS_TARIF,
 TARIF_BM
) as (
SELECT
 ROW_NUMBER() OVER (PARTITION BY a.idpebhdr ORDER BY a.idpebhdr),
 a.idpebhdr AS id_bc_out_hdr,
 a.CAR,
 a.NODAFT,
 a.TGDAFT,
 a.TGDAFT AS doc_out_date,
 b.SERIBRG,
 b.KDBRG,
 COncat(b.URBRG1, ' ', b.URBRG2,' ',b.URBRG3) as URAIAN
 , b.JMSATUAN
 , b.JNSATUAN
 , b.DnilInv 
 , b.HS
 ,'10'
 FROM 
 AW.DB_PASI_20201106.dbo.tblPebDtl b
 INNER JOIN
 AW.DB_PASI_20201106.dbo.tblPebHdr a ON b.idpebhdr = a.idpebhdr
 where a.NODAFT is not null AND a.TGDAFT is not null
  AND (a.TGDAFT BETWEEN @start_date AND @end_date)
 
)
,
ct_sumary_detail (
 urut,
 id_bc_out_hdr,
 JUMLAH_KEMASAN,
 CIF
) as (
 SELECT
 ROW_NUMBER() OVER (PARTITION BY a.idpebhdr ORDER BY a.idpebhdr),
 a.idpebhdr
 , sum(isnull(b.JMKOLI,0)) as KemasJm
 , sum(isnull(b.DNilInv,0)) as CIF
 FROM AW.DB_PASI_20201106.dbo.tblPebDtl b
 INNER JOIN
 AW.DB_PASI_20201106.dbo.tblPebHdr a ON b.idpebhdr = a.idpebhdr
 where a.NODAFT is not null AND a.TGDAFT is not null
 AND (a.TGDAFT BETWEEN @start_date AND @end_date)
 GROUP BY a.idpebhdr
)
,
ct_sumary_header (
 urut,
 id_bc_out_hdr,
 BRUTO,
 CIF,
 KPBC,
 NDPBM,
 NAMA_PENERIMA,
 NAMA_ANGKUT
) as (
 SELECT
 ROW_NUMBER() OVER (PARTITION BY a.idpebhdr ORDER BY a.idpebhdr),
 idpebhdr
 , BRUTO
 , NilInv
 ,KDKTR
 , dbo.get_rate_valuta(a.TGDAFT,KDVAL)
 , NAMABELI
 , CARRIER
 FROM 
 AW.DB_PASI_20201106.dbo.tblPebHdr a
 where a.NODAFT is not null AND a.TGDAFT is not null
 AND (a.TGDAFT BETWEEN @start_date AND @end_date)
)
,
ct_invoice (
 urut,
 id_bc_out_hdr,
 NOMOR_DOKUMEN,
 TANGGAL_DOKUMEN,
 AMOUNT_INVOICE
) as (
 SELECT
 ROW_NUMBER() OVER (PARTITION BY a.idpebhdr ORDER BY a.idpebhdr),
 a.idpebhdr
 , b.NoDok
 , b.TgDok
 , a.NilInv

 FROM AW.DB_PASI_20201106.dbo.tblPebDok b
 LEFT OUTER JOIN
 AW.DB_PASI_20201106.dbo.tblPebHdr a ON b.idpebhdr = a.idpebhdr
 where a.NODAFT is not null AND a.TGDAFT is not NULL
    AND b.KdDok= '380'
 AND (a.TGDAFT BETWEEN @start_date AND @end_date)
)
,
ct_bl (
 urut,
 id_bc_out_hdr,
 NOMOR_DOKUMEN,
 TANGGAL_DOKUMEN
) as (
 SELECT
 ROW_NUMBER() OVER (PARTITION BY a.idpebhdr ORDER BY a.idpebhdr),
 a.idpebhdr
 , b.NoDok
 , b.TgDok
 
 FROM AW.DB_PASI_20201106.dbo.tblPebDok b
 LEFT OUTER JOIN
 AW.DB_PASI_20201106.dbo.tblPebHdr a ON b.idpebhdr = a.idpebhdr
 where a.NODAFT is not null AND a.TGDAFT is not NULL
    AND b.KdDok  IN ('705', '740')
 AND (a.TGDAFT BETWEEN @start_date AND @end_date)

),
ct_cont (
 urut,
 id_bc_out_hdr,
 NOMOR_KONTAINER,
 UKURAN_KONTAINER
) as (
 SELECT
 ROW_NUMBER() OVER (PARTITION BY a.idpebhdr ORDER BY a.idpebhdr),
 a.idpebhdr
 , b.NoCont
 , b.Size

 FROM AW.DB_PASI_20201106.dbo.tblPebCon b
 LEFT OUTER JOIN
 AW.DB_PASI_20201106.dbo.tblPebHdr a ON b.idpebhdr = a.idpebhdr
 where a.NODAFT is not null AND a.TGDAFT is not NULL
 AND (a.TGDAFT BETWEEN @start_date AND @end_date)
)

insert into @rpt_out_bc30 (data_source
, NOMOR_AJU
, NOMOR_DAFTAR
, TANGGAL_DAFTAR
, KODE_DOKUMEN_PABEAN
, TANGGAL_KELUAR
, SERI_BARANG
, KODE_BARANG
, URAIAN
, JUMLAH_SATUAN
, KODE_SATUAN
, JUMLAH_KEMASAN
, BRUTO
, CIF
, KPBC
, CIF_DETAIL
, POS_TARIF
, NOMOR_INVOICE
, TANGGAL_INVOICE
, NOMOR_BL
, TANGGAL_BL
, NDPBM
, CIF_RUPIAH
, TARIF_BM
, NAMA_PENERIMA
, NAMA_ANGKUT
, NOMOR_KONTAINER
, UKURAN_KONTAINER
, AMOUNT_INVOICE)
SELECT 'AW' 
, a.NOMOR_AJU
, a.NOMOR_DAFTAR
, a.TANGGAL_DAFTAR
, 'BC30'
, a.TANGGAL_KELUAR
, a.SERI_BARANG
, a.KODE_BARANG
, a.URAIAN
, a.JUMLAH_SATUAN
, a.KODE_SATUAN
, b.JUMLAH_KEMASAN
, c.BRUTO
, b.CIF
, c.KPBC
, a.CIF
, a.POS_TARIF
, d.NOMOR_DOKUMEN
, d.TANGGAL_DOKUMEN
, e.NOMOR_DOKUMEN
, e.TANGGAL_DOKUMEN
, c.NDPBM
, a.CIF * g.NDPBM
, a.TARIF_BM
, c.NAMA_PENERIMA
, c.NAMA_ANGKUT
, f.NOMOR_KONTAINER
, f.UKURAN_KONTAINER
, d.AMOUNT_INVOICE
from cte_hdr a
LEFT JOIN ct_sumary_detail b ON a.id_bc_out_hdr = b.id_bc_out_hdr AND a.urut = b.urut
LEFT JOIN ct_sumary_header c ON a.id_bc_out_hdr = c.id_bc_out_hdr AND a.urut = c.urut
LEFT JOIN ct_invoice d ON a.id_bc_out_hdr = d.id_bc_out_hdr AND a.urut = d.urut
LEFT JOIN ct_bl e ON a.id_bc_out_hdr = e.id_bc_out_hdr AND a.urut = e.urut
LEFT JOIN ct_cont f ON a.id_bc_out_hdr = f.id_bc_out_hdr AND a.urut = f.urut
LEFT JOIN ct_sumary_header g ON a.id_bc_out_hdr = g.id_bc_out_hdr AND g.urut = 1
ORDER BY a.NOMOR_AJU, a.SERI_BARANG

  end

 RETURN;

end; 

GO
