<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

function objectToArray($d) {
	if (is_object($d)) {
		// Gets the properties of the given object
		// with get_object_vars function
		$d = get_object_vars($d);
	}

	if (is_array($d)) {
		/*
		* Return array converted to object
		* Using __FUNCTION__ (Magic constant)
		* for recursive call
		*/
		return array_map(__FUNCTION__, $d);
	}
	else {
		// Return array
		return $d;
	}
}
function arrayToObject($d) {
	if (is_array($d)) {
		/*
		* Return array converted to object
		* Using __FUNCTION__ (Magic constant)
		* for recursive call
		*/
		return (object) array_map(__FUNCTION__, $d);
	}
	else {
		// Return object
		return $d;
	}
}
/**
 * @param array $array the array to be converted
 * @param string? $rootElement if specified will be taken as root element, otherwise defaults to
 *                <root>
 * @param SimpleXMLElement? if specified content will be appended, used for recursion
 * @return string XML version of $array
 */
function arrayToXml($array, $rootElement = null, $xml = null) {
  $_xml = $xml;
 
  if ($_xml === null) {
    $_xml = new SimpleXMLElement($rootElement !== null ? $rootElement : '<root/>');
  }
 
  foreach ($array as $k => $v) {
    if (is_array($v)) { //nested array
      arrayToXml($v, $k, $_xml->addChild($k));
    } else {
      $_xml->addChild($k, $v);
    }
  }
 
  return $_xml->asXML();
}

function cleanse($string, $allowedTags = array())
{
	if (get_magic_quotes_gpc()) {
		$string = stripslashes($stringIn);
	}
	// $string = kses($string, $allowedTags); // For kses {@see http://sourceforge.net/projects/kses/}
	 
	// ============
	// Remove MS Word Special Characters
	// ============
	$search = array('&acirc;','&acirc;','&acirc;','&acirc;','&Acirc;&pound;','&Acirc;&not;','&acirc;&cent;','&acirc;','&nbsp;');
	$replace = array('-','&ldquo;','&lsquo;','&rsquo;','&pound;','&not;','&#8482;');
	$string = str_replace($search, $replace, $string);
	$string = str_replace('&acirc;', '&rdquo;', $string);
	 
	$search = array("&#39;", "\xc3\xa2\xc2\x80\xc2\x99", "\xc3\xa2\xc2\x80\xc2\x93", "\xc3\xa2\xc2\x80\xc2\x9d", "\xc3\xa2\x3f\x3f");
	$resplace = array("'", "'", ' - ', '"', "'");
	$string = str_replace($search, $replace, $string);
	 
	$quotes = array(
		"\xC2\xAB" => '"',
		"\xC2\xBB" => '"',
		"\xE2\x80\x98" => "'",
		"\xE2\x80\x99" => "'",
		"\xE2\x80\x9A" => "'",
		"\xE2\x80\x9B" => "'",
		"\xE2\x80\x9C" => '"',
		"\xE2\x80\x9D" => '"',
		"\xE2\x80\x9E" => '"',
		"\xE2\x80\x9F" => '"',
		"\xE2\x80\xB9" => "'",
		"\xE2\x80\xBA" => "'",
		"\xe2\x80\x93" => "-",
		"\xc2\xb0"	=> "",
		"\xc2\xba" => "",
		"\xc3\xb1"	=> "&#241;",
		"\x96"	=> "&#241;",
		"\xe2\x81\x83" => '&bull;',
		"\xd5" => "'"
	);
	$string = strtr($string, $quotes);
	/*
	// Use the below to get the byte of the special char and put it in the array above + the replacement.
	if (strpos($string, "Live Wave Buoy Data") !== false)
	{
	for ($i=strpos($string, "Live Wave Buoy Data") ; $i<strlen($string) ; $i++) {
	$byte = $string[$i];
	$char = ord($byte);
	printf('%s:0x%02x ', $byte, $char);
	}
	}
	var_dump($string);
	exit;
	*/
	// ============
	// END
	// ============
	return $string;
}