<?php
class MDL_outgoing extends CI_Model
{	
	
	function __construct()
    {
        parent::__construct();
		
	}
	
	function data_out_hdr_All($limit,$start,$sidx,$sord, $where){
		$this->db->select("
			tbl_data_out_hdr.id_data_out_hdr, 
			tbl_data_out_hdr.doc_out_no, 
			convert(varchar, tbl_data_out_hdr.doc_out_date,101) as  doc_out_date, 
			tbl_data_out_hdr.doc_out_to_id, 
            tbl_data_out_hdr.id_data_out_hdr_h_status, 
			tbl_data_out_hdr.id_terkait,
			convert(varchar, tbl_data_out_hdr.approve_date,101) as  approve_date, 
			enum_data_out_to.doc_out_to_name, 
			tbl_data_out_hdr_h_status.status
			
		");

		$this->db->from("tbl_data_out_hdr");
		$this->db->join("tbl_data_out_hdr_h_status" , "tbl_data_out_hdr.id_data_out_hdr_h_status = tbl_data_out_hdr_h_status.id_data_out_hdr_h_status", "INNER");
		$this->db->join("enum_data_out_to" , "tbl_data_out_hdr.doc_out_to_id = enum_data_out_to.doc_out_to_id", "INNER");
		$this->db->where($where);
        $this->db->limit($limit,$start);
        $this->db->order_by($sidx,$sord);
        $result = $this->db->get()->result(); 
        //die($this->db->last_query());
        return $result;
		
	}
	
	function data_out_hdr_CountAll($where){
		$this->db->select("
			tbl_data_out_hdr.id_data_out_hdr
		");
		$this->db->from("tbl_data_out_hdr");
		$this->db->join("tbl_data_out_hdr_h_status" , "tbl_data_out_hdr.id_data_out_hdr_h_status = tbl_data_out_hdr_h_status.id_data_out_hdr_h_status", "INNER");
		$this->db->join("enum_data_out_to" , "tbl_data_out_hdr.doc_out_to_id = enum_data_out_to.doc_out_to_id", "INNER");
		$this->db->where($where);
		//$this->db->group_by(array("a.inv_hdr_id", "b.part_name_customs","a.r7")); 
        $query = $this->db->get();
		$rowcount = $query->num_rows();
		return $rowcount;
	}
	
	function data_vgi_all($limit,$start,$sidx,$sord, $where){
		$this->db->select("
			 [id_vgi_hdr]
			 ,[from_file_name]
			 ,convert(varchar, [exec_date], 101) as exec_date
			 ,itemcount
			 ,status
			 ,ISSUE_NO
			 ,convert(varchar, REG_DATE, 101) as REG_DATE
			 
		");
		$this->db->from("tbl_vgi_hdr");
        $this->db->where($where);
        $this->db->limit($limit,$start);
        $this->db->order_by($sidx,$sord);
        $result = $this->db->get()->result(); 
        //die($this->db->last_query());
        return $result;
	
	
	}
	
	function data_vgi_CountAll($where){
	
		$this->db->select("*");
        $this->db->from("tbl_vgi_hdr");
        $this->db->where($where);
        $result = $this->db->count_all_results(); 
        return $result;
	
	
	}
	
	function data_vgi_dtl_all($limit,$start,$sidx,$sord, $where){
	
		$this->db->select("
			tbl_vgi_dtl.id_vgi_dtl, 
			tbl_vgi_dtl.id_vgi_hdr, 
			convert(varchar, tbl_vgi_dtl.vgi_date,101) as vgi_date, 
			tbl_vgi_dtl.r1 as note, 
			tbl_vgi_dtl.r2 as assycode, 
			tbl_vgi_dtl.part_number, 
			tbl_vgi_dtl.qty, 
			tbl_data_part_hs.part_no, 
            tbl_data_part_hs.part_name, 
			tbl_data_part_hs.part_name_customs
		");

		$this->db->from("tbl_vgi_dtl");
		$this->db->join("tbl_data_part_hs" , "tbl_vgi_dtl.part_number = tbl_data_part_hs.part_no", "LEFT OUTER");
		$this->db->where($where);
        $this->db->limit($limit,$start);
        $this->db->order_by($sidx,$sord);
        $result = $this->db->get()->result(); 
        //die($this->db->last_query());
        return $result;
	
	
	}
	
	function data_vgi_dtl_CountAll($where){
	
		$this->db->select("
			tbl_vgi_dtl.id_vgi_dtl
		");
		$this->db->from("tbl_vgi_dtl");
		$this->db->join("tbl_data_part_hs" , "tbl_vgi_dtl.part_number = tbl_data_part_hs.part_no", "LEFT OUTER");
		$this->db->where($where);
		
        $query = $this->db->get();
		$rowcount = $query->num_rows();
		return $rowcount;
			
	}
	
	function data_vgi_dtl_null($where){
		
		$this->db->select("
			tbl_vgi_dtl.id_vgi_dtl
		");
		$this->db->from("tbl_vgi_dtl");
		$this->db->join("tbl_data_part_hs" , "tbl_vgi_dtl.part_number = tbl_data_part_hs.part_no", "LEFT OUTER");
		$this->db->where($where);
		$query = $this->db->get();
		$rowcount = $query->num_rows();
		return $rowcount;
		
	}
	
	function data_stocktransfer_dtl_all($limit,$start,$sidx,$sord, $where){
		$this->db->select("
			[id_data_out_dtl]
			  ,tbl_data_out_dtl.[id_data_out_hdr]
			  ,[id_part_number]
			  ,[out_date]
			  ,[part_name_customs]
			  ,[part_number]
			  ,[qty]
			  ,[qty_supply]
			  ,[unit_out]
			  ,[unit_konversi]
			  ,[pengali]
			  ,[box]
			  ,[pack]
			  ,[assy_code]
			  ,tbl_data_out_hdr.doc_out_no
			 
		");

		$this->db->from("[tbl_data_out_dtl]");
		$this->db->join("tbl_data_out_hdr" , "tbl_data_out_dtl.id_data_out_hdr = tbl_data_out_hdr.id_data_out_hdr", "INNER");
		$this->db->where($where);
        $this->db->limit($limit,$start);
        $this->db->order_by($sidx,$sord);
        $result = $this->db->get()->result(); 
       // die($this->db->last_query());
        return $result;
	
	
	}
	
	function data_stocktransfer_dtl_CountAll($where){
	
	$this->db->select("*");
        $this->db->from("[tbl_data_out_dtl]");
	$this->db->join("tbl_data_out_hdr" , "tbl_data_out_dtl.id_data_out_hdr = tbl_data_out_hdr.id_data_out_hdr", "INNER");
	$this->db->where($where);
        $result = $this->db->count_all_results(); 
        return $result;
	
			
	}
	
	function datainv_proses_out_all($limit,$start,$sidx,$sord, $where){
		$query = $this->db->query("
		   
			;with
			 ctedata(id_bc_out, namapembeli, typedok, statusdok)
			 as
			 (
				SELECT     tbl_bc_out_hdr.id_bc_out_hdr, NAMABELI, [typedok],statusdok 
				FROM         tbl_bc_out_hdr 
				union all
				SELECT  dbo.tbl_sa_hdr.id_sa_hdr,NAMA_PEMBELI, [typedok],status
				FROM   dbo.tbl_sa_hdr 
			 )
			 
			select * from (
			select  ctedata.id_bc_out, ROW_NUMBER() OVER (ORDER BY id_bc_out) as row,  ctedata.namapembeli, ctedata.statusdok, ctedata.typedok from ctedata
			where   $where  ) as x
			where x.row between $start and (1+$start)*$limit
			order by $sidx $sord 
			
			
		");

		
      //  $result = $this->db->get()->result(); 
       // die($this->db->last_query());
        
		$result = $query->result_array();
		//var_dump($result);
		//die();
		return $result;
	
	
	}
	
	function datainv_proses_out_CountAll($where){
	
		/* $this->db->select("*");
        $this->db->from("tbl_data_out_dtl");
        $this->db->where($where);
        $result = $this->db->count_all_results(); 
        return $result; */
		$query = $this->db->query("
			;with
			 ctedata(id_bc_out, namapembeli, typedok, statusdok)
			 as
			 (
				SELECT     tbl_bc_out_hdr.id_bc_out_hdr, NAMABELI, [typedok],statusdok 
				FROM         tbl_bc_out_hdr 
				union all
				SELECT  dbo.tbl_sa_hdr.id_sa_hdr,NAMA_PEMBELI, [typedok],status
				FROM   dbo.tbl_sa_hdr 
			 )
			select count(*) as cnt from ctedata	
		
		");
		$result = $query->result_array();
		foreach ( $result as $row ){
		 
			$result = $row['cnt'];
		 }
		 return $result;
			
	}
	
	function detilitem_proses_out_all($limit,$start,$sidx,$sord, $where){
		$query = $this->db->query("
		
			with
			 ctedata(id_bc_out, typebc, ASSY_CODE, ASSY_NO,TOTAL_SET, SATUAN, NETDET, KGM )
			 as
			 (
				SELECT     tbl_bc_out_hdr.id_bc_out_hdr, tbl_bc_out_hdr.typedok, tbl_bc_out_dtl.KDBRG, tbl_bc_out_dtl.URBRG1, tbl_bc_out_dtl.JMSATUAN, tbl_bc_out_dtl.JNSATUAN, 
                      tbl_bc_out_dtl.NETDET, 'KGM'
				FROM         tbl_bc_out_hdr INNER JOIN
                      tbl_bc_out_dtl ON tbl_bc_out_hdr.id_bc_out_hdr = tbl_bc_out_dtl.id_bc_out_hdr
				UNION ALL
				select  id_sa_hdr, 'BC25', ASSY_CODE, ASSY_NO, TOTAL_SET, SATUAN, NETWEIGHT, 'KGM'  from [tbl_sa]
				
			 )
			select * from (
			select  id_bc_out, ROW_NUMBER() OVER (ORDER BY id_bc_out) as row, typebc, ASSY_CODE, ASSY_NO, TOTAL_SET,  SATUAN, NETDET, KGM from ctedata
			where   $where  ) as x
			where x.row between $start and (1+$start)*$limit
			order by $sidx $sord
			
			
		");

		
      //  $result = $this->db->get()->result(); 
       //die($this->db->last_query());
        
		$result = $query->result_array();
		//var_dump($result);
		//die();
		return $result;
	
	
	}
	
	function detilitem_proses_out_CountAll($where){
	
		$query = $this->db->query("
			;with
			 ctedata(id_bc_out, typebc, ASSY_CODE, ASSY_NO,TOTAL_SET, SATUAN, NETDET, KGM )
			 as
			 (
				select id_bc_out_hdr, 'BC30', KDBRG, URBRG1, JMSATUAN, JNSATUAN, NETDET, 'KGM'  from [tbl_bc_out_dtl]
				UNION ALL
				select id_sa_hdr, 'BC25', ASSY_CODE, ASSY_NO, TOTAL_SET, SATUAN, NETWEIGHT, 'KGM'  from [tbl_sa]
				
			 )
			 select COUNT(*) as cnt from ctedata where  $where
		
		");
		$result = $query->result_array();
		foreach ( $result as $row ){
		 
			$result = $row['cnt'];
		 }
		 return $result;
			
	}
	
	function data_fg_load_stock_all($limit,$start,$sidx,$sord, $where,$wheredate, $date1, $date2){
		
		$query = $this->db->query("
		
			declare @mutasibj table (
				part_no varchar(100) null
				,part_name varchar(100) null
				,stock_awal float null
				,qty_in float null
				,qty_out float null
				,sisa float null
				,unit varchar(100) null
				,qty_in_by_date float null
				,qty_out_by_date float null
				,sisa_by_date float null
				)
			;with
			 ct_assy_list(
					part_no,part_name
				 ) as
				 (
					SELECT 
						 [ASSY_CODE]
						  ,[ASSY_NO]
					      
					  FROM [dbo].[tbl_assy_list]
					  group by 
						[ASSY_CODE]
						  ,[ASSY_NO]
				 ),
				 ctestok_trxawal(
					part_no, part_name, qty_in, unit
				 
				 ) as
				 (
					select part_no, part_name, sum(qty_in), unit_in 
					from tbl_data_in_dtl inner join tbl_data_in_hdr on tbl_data_in_hdr.id_data_in_hdr = tbl_data_in_dtl.id_data_in_hdr
					where type_brg=2 and status='APPROVED'
					group by  part_no, part_name,unit_in
				 ),
				 ctest_trxoutawal(part_no, part_name,qty_out, unit) as (
					SELECT     assy_code, part_name_customs, sum(qty), unit_out
					FROM         tbl_data_out_dtl
					where type_items='FG'
					group by
					assy_code, part_name_customs,unit_out
				 ),
				 ctestokawal(part_no, qty) as (
					select part_no, qty from dbo.saldoawal('$date1','$date2','FG')
				 ),
				  ctestok_in_date(
					part_no, part_name, qty_in
				 
				 ) as
				 (
					select part_no, part_name, sum(qty_in) as qty_in
					from tbl_data_in_dtl inner join tbl_data_in_hdr on tbl_data_in_hdr.id_data_in_hdr = tbl_data_in_dtl.id_data_in_hdr
					where type_brg=2 and status='APPROVED' and tbl_data_in_hdr.doc_in_date between   $wheredate
					group by  part_no, part_name,unit_in
				 ),
				 ctest_trxout_bydate(part_no, part_name,qty_out, unit) as (
					SELECT     assy_code, part_name_customs, sum(qty), unit_out
					FROM         tbl_data_out_dtl
					where type_items='FG' and out_date between   $wheredate 
					group by
					assy_code, part_name_customs,unit_out
				 )
				
					 
                  insert into @mutasibj (part_no,part_name,stock_awal,qty_in,qty_out,sisa,unit,qty_in_by_date,qty_out_by_date,sisa_by_date 
                  )
				SELECT 
				
				 ct_assy_list.part_no
				 , ct_assy_list.part_name
				 ,isnull(ctestokawal.qty,0) as stok_awal
				 ,isnull(ctestok_trxawal.qty_in, 0) as qty_in
				 ,isnull(ctest_trxoutawal.qty_out, 0) as qty_out
				 ,(isnull(ctestokawal.qty,0) + isnull(ctestok_trxawal.qty_in,0)) -  isnull(ctest_trxoutawal.qty_out, 0) as sisa
				 ,(isnull(ctestok_trxawal.unit, 'PCE')) as unit
				 ,isnull(ctestok_in_date.qty_in,0) as qty_in_by_date
				 ,isnull(ctest_trxout_bydate.qty_out,0) as qty_out_by_date
				  ,((isnull(ctestokawal.qty,0) + isnull(ctestok_in_date.qty_in,0)) - (isnull(ctest_trxout_bydate.qty_out,0))) as sisa_by_date 
				 from ct_assy_list 
				 left outer join ctestok_trxawal on ct_assy_list.part_no = ctestok_trxawal.part_no
				 left outer join ctest_trxoutawal on ct_assy_list.part_no=ctest_trxoutawal.part_no
				 left outer join ctestokawal on ct_assy_list.part_no=ctestokawal.part_no
				 left outer join ctestok_in_date on ct_assy_list.part_no=ctestok_in_date.part_no
				 left outer join ctest_trxout_bydate on ct_assy_list.part_no=ctest_trxout_bydate.part_no
				 
				 select * from (
					 select 
						row_number() OVER (ORDER BY part_no) AS row,
						part_no,
						part_name,
						stock_awal,
						qty_in,
						qty_out,
						sisa,
						unit,
						qty_in_by_date,
						qty_out_by_date,
						sisa_by_date
						from @mutasibj
						where  $where and (stock_awal <> 0 or qty_in <> 0 or qty_out <> 0 or qty_in_by_date <> 0 or qty_out_by_date <> 0)  
				 ) x where x.row between $start and (1+$start)*$limit
			    order by x.part_no asc
				--order by $sidx $sord
			
		");

		
      //  $result = $this->db->get()->result(); 
        //die($this->db->last_query());
        
		$result = $query->result_array();
		//var_dump($result);
		//die();
		return $result;
	
	
	}
	
	function data_fg_load_stock_CountAll($where, $wheredate){
			$query = $this->db->query("
		
			declare @mutasibjx table (
				part_no varchar(100) null
				,part_name varchar(100) null
				,stock_awal float null
				,qty_in float null
				,qty_out float null
				,sisa float null
				,unit varchar(100) null
				,qty_in_by_date float null
				,qty_out_by_date float null
				
				)
			;with
			 ct_assy_list(
					part_no,part_name
				 ) as
				 (
					SELECT 
						 [ASSY_CODE]
						  ,[ASSY_NO]
					      
					  FROM [dbo].[tbl_assy_list]
					  group by 
						[ASSY_CODE]
						  ,[ASSY_NO]
				 ),
				 ctestok_trxawal(
					part_no, part_name, qty_in, unit
				 
				 ) as
				 (
					select part_no, part_name, sum(qty_in), unit_in 
					from tbl_data_in_dtl inner join tbl_data_in_hdr on tbl_data_in_hdr.id_data_in_hdr = tbl_data_in_dtl.id_data_in_hdr
					where type_brg=2 and status='APPROVED'
					group by  part_no, part_name,unit_in
				 ),
				 ctest_trxoutawal(part_no, part_name,qty_out, unit) as (
					SELECT     assy_code, part_name_customs, sum(qty), unit_out
					FROM         tbl_data_out_dtl
					where type_items='FG'
					group by
					assy_code, part_name_customs,unit_out
				 ),
				 ctestokawal(part_no, qty) as (
					select part_no, qty	from dbo.tbl_stock_awal
				 ),
				  ctestok_in_date(
					part_no, part_name, qty_in
				 
				 ) as
				 (
					select part_no, part_name, sum(qty_in) as qty_in
					from tbl_data_in_dtl inner join tbl_data_in_hdr on tbl_data_in_hdr.id_data_in_hdr = tbl_data_in_dtl.id_data_in_hdr
					where type_brg=2 and status='APPROVED' and tbl_data_in_hdr.doc_in_date between   $wheredate
					group by  part_no, part_name,unit_in
				 ),
				 ctest_trxout_bydate(part_no, part_name,qty_out, unit) as (
					SELECT     assy_code, part_name_customs, sum(qty), unit_out
					FROM         tbl_data_out_dtl
					where type_items='FG' and out_date between   $wheredate 
					group by
					assy_code, part_name_customs,unit_out
				 )
				
					 
                  insert into @mutasibjx (part_no,part_name,stock_awal,qty_in,qty_out,sisa,unit,qty_in_by_date,qty_out_by_date
                  )
				SELECT 
				
				 ct_assy_list.part_no
				 , ct_assy_list.part_name
				 ,isnull(ctestokawal.qty,0) as stok_awal
				 ,isnull(ctestok_trxawal.qty_in, 0) as qty_in
				 ,isnull(ctest_trxoutawal.qty_out, 0) as qty_out
				 ,(isnull(ctestokawal.qty,0) + isnull(ctestok_trxawal.qty_in,0)) -  isnull(ctest_trxoutawal.qty_out, 0) as sisa
				 ,(isnull(ctestok_trxawal.unit, 'PCE')) as unit
				 ,isnull(ctestok_in_date.qty_in,0) as qty_in_by_date
				 ,isnull(ctest_trxout_bydate.qty_out,0) as qty_out_by_date
				
				 from ct_assy_list 
				 left outer join ctestok_trxawal on ct_assy_list.part_no = ctestok_trxawal.part_no
				 left outer join ctest_trxoutawal on ct_assy_list.part_no=ctest_trxoutawal.part_no
				 left outer join ctestokawal on ct_assy_list.part_no=ctestokawal.part_no
				 left outer join ctestok_in_date on ct_assy_list.part_no=ctestok_in_date.part_no
				 left outer join ctest_trxout_bydate on ct_assy_list.part_no=ctest_trxout_bydate.part_no
				 
				 select 
					count(*) as cnt
					from @mutasibjx
			  
				where  $where and (stock_awal <> 0 or qty_in <> 0 or qty_out <> 0 or qty_in_by_date <> 0 or qty_out_by_date <> 0) 
				
			
		");

		
      //  $result = $this->db->get()->result(); 
        //die($this->db->last_query());
        
		$result = $query->result_array();
		//var_dump($result);
		//die();
		$xx=0;
		foreach ($result as $r){
			$xx=$r['cnt'];
		}
		return $xx;
	
	
	}
	
	function data_report_per_part_all($limit,$page,$sidx,$sord, $where, $tglawal, $tglakhir){
		$query = $this->db->query(
		"	
			select * from (
				select
					row_number() OVER (ORDER BY kodebarang) AS row 
					,kodebarang
					,namabarang
					,qty_saldoawal
					,qty_in
					,qty_out
					,saldo_akhir
					,unit
					,stock_opname
					,selisih
					,adj
					,(		 case when sto = 0 then
		 0
		 else 
		 (stock_opname-saldo_akhir)
		 end
		 ) as selish
				from dbo.f_mutasi_bb_per_partx('$tglawal','$tglakhir')
			where   $where  ) as x
				where x.row between  ($page - 1) * $limit + 1 AND $page * $limit
				order by $sidx $sord 	
		
		
		");
		$result = $query->result_array();
		//var_dump($result);
		//die();
		return $result;
	
	}
	
	function data_report_per_part_CountAll($where, $tgl_awal, $tgl_akhir){
		 $query = $this->db->query("
			
			select COUNT(*) as cnt from (
			select row_number() OVER (ORDER BY kodebarang) AS row, 
			kodebarang
			from dbo.f_mutasi_bb_per_partx('$tgl_awal','$tgl_akhir')
			
			) x
		 ");

        $result = $query->result_array();
		//var_dump($result);
		//die();
		$xx=0;
		foreach ($result as $r){
			$xx=$r['cnt'];
		}
		return $xx; 
		
	
	
	}
	
	function data_file_cooAll($limit,$start,$sidx,$sord, $where, $tipe, $filename,$ext){
		$this->db->select("
		   
		    [datanama]
      ,[file_name]
      ,[ukuran]
       ,datecreate
			
		  
			
		");
		$this->db->from("[dbo].[f_upload_coo]('$tipe','$filename','$ext') ");
		$this->db->where($where);
		$this->db->limit($limit,$start);
        $this->db->order_by($sidx,$sord);
        $result = $this->db->get()->result();
		//die($this->db->last_query());	
        return $result;
	
	}
	function data_file_coocountAll($where, $tipe, $filename,$ext){
		$this->db->select("*");
        $this->db->from("[dbo].[f_upload_coo]('$tipe','$filename','$ext') ");
        $this->db->where($where);
        $result = $this->db->count_all_results(); 
        //die($this->db->last_query());
        return $result;
	}
	
}
	