<?php
class MDL_main extends CI_Model
{
	function __construct()
    {
        parent::__construct();
       	$this->_prefix = $this->config->item('DX_table_prefix');
		$this->_users_table = $this->_prefix.$this->config->item('DX_users_table');	
		$this->_users_profile_table = $this->_prefix.$this->config->item('DX_user_profile_table');	
		$this->_users_roles_table = $this->_prefix.$this->config->item('DX_roles_table');	
		$this->_roles_table = $this->_prefix.$this->config->item('DX_roles_table');
        $this->_permissions_table = $this->_prefix . $this->config->item('DX_permissions_table');
	}
	
    function getAllMenuType2($level_id){
		mssql_query('SET CONCAT_NULL_YIELDS_NULL ON'); 
		mssql_query('SET ANSI_WARNINGS ON'); 
		mssql_query('SET ANSI_PADDING ON'); 
		$result['data'] =$this->db->query("mg_menu_tree '".$level_id."'" )->result();  
        return $result;
	}
	
   function getAllAcc(){
		mssql_query('SET CONCAT_NULL_YIELDS_NULL ON'); 
		mssql_query('SET ANSI_WARNINGS ON'); 
		mssql_query('SET ANSI_PADDING ON'); 
		$result['data'] =$this->db->query("mg_menu_tree_acc '".$this->session->userdata('DX_user_id')."'" )->result();  
        return $result;
	}
    function getAllMenuType(){
		$this->db->select("*");
        $this->db->from('ccs_menu_types');
        //$this->db->where('id !=', 8);
        //$this->db->where('id !=', 9);
        $result['data'] = $this->db->get()->result(); 
        return $result;
	}
    
    function getAllMenuTypeCount(){
        $this->db->from('ccs_menu_types');
        $result = $this->db->count_all_results();  
        return $result;
	}
    
    function getAllMenuTypeData($limit,$start,$sidx,$sord){
		$this->db->select("*");
        $this->db->from('ccs_menu_types');
        $this->db->limit($limit,$start);
        $this->db->order_by($sidx,$sord);
        $result = $this->db->get()->result(); 
        return $result;
	}
    
	function getAllMenu($params){
		$this->db->select("*");
        $this->db->from('ccs_menu');
        //$this->db->where('published', 1);
        $this->db->where('menutype', $params);
        $this->db->where('parent_id', 0);
        $this->db->order_by("ordering", "asc");
        
        //$this->db->limit(20);
        //$result['exec'] = $this->db->get();
        
        $result['data'] = $this->db->get()->result(); 
        //die($this->db->last_query());
        return $result;
	}
    
    function getAllChildMenu($pid){
		$this->db->select("*");
        $this->db->from('ccs_menu');
        $this->db->where('parent_id', $pid);
        $this->db->order_by("ordering", "asc"); 
        //$this->db->limit(20);
        $result['data'] = $this->db->get()->result(); 
        return $result;
	}
    
    function getMenu($params){
		$this->db->select("*");
        $this->db->from('ccs_menu');
        $this->db->where('published', 1);
	    $this->db->where('menutype', $params); 
        $this->db->where('parent_id', 0);
        if($this->session->userdata('DX_user_id') != AID && $this->session->userdata('DX_user_id') != RID){
            $this->db->where('alias !=', 'application');
        }
        $this->db->order_by("ordering", "asc");
        //$this->db->limit(20);
        //$result['exec'] = $this->db->get();
        
        $result['data'] = $this->db->get()->result(); 
        //die($this->db->last_query());
        return $result;
	}
     
    function getMenuTree($params){
		$this->db->select("*");
        $this->db->from('ccs_menu');
        $this->db->where('published', 1);
	    $this->db->where('note', 'folder');
	    $this->db->where('link', '#');
      	 
       $this->db->where('parent_id', 0);
        if($this->session->userdata('DX_user_id') != AID && $this->session->userdata('DX_user_id') != RID){
            $this->db->where('alias !=', 'application');
        }
        $this->db->order_by("ordering", "asc");
        //$this->db->limit(20);
        //$result['exec'] = $this->db->get();
        
        $result['data'] = $this->db->get()->result(); 
        //die($this->db->last_query());
        return $result;
	}
     
    function getChildMenu($pid){
		$this->db->select("*");
        $this->db->from('ccs_menu');
        $this->db->where('published', 1);
        $this->db->where('parent_id', $pid);
        if($this->session->userdata('DX_user_id') != RID){
            $this->db->where('alias !=', 'menu_management');
        }

        $this->db->order_by("ordering", "asc"); 
        //$this->db->limit(20);
        $result['data'] = $this->db->get()->result(); 
        return $result;
	}
    
    function getAccordionMenu($role_id){
	    $this->db->select('perm_menutype');
    	$this->db->from('ccs_permissions');
    	$this->db->where('role_id',$role_id);
    
    	$res = $this->db->get()->result();
        
        $menu = explode(",",$res[0]->perm_menutype);  
       
        $this->db->select("*");
        $this->db->from('ccs_menu_types');
        $this->db->where('published_menutype', 1);
        $this->db->where_in('id', $menu);
        $this->db->order_by("[order]", "asc");
        $result = $this->db->get()->result(); 
        return $result;
	}
    
    function getFrontPageMenu($role_id){
        
   	    $this->db->select('perm_menutype');
    	$this->db->from('ccs_permissions');
    	$this->db->where('role_id',$role_id);
    
    	$res = $this->db->get()->result();
        
        $menu = explode(",",$res[0]->perm_menutype); 
		
        $this->db->select("*");
        $this->db->from('ccs_menu_types');
        $this->db->where('published_menutype', 1);
        $this->db->where('id !=', 8);
        $this->db->where('id !=', 9);
        $this->db->where_in('id', $menu);
        $this->db->order_by("[order]", "asc"); 
        $result = $this->db->get()->result(); 
        return $result;
	}
    
    
    
    function getAllUsers($limit,$start,$sidx,$sord){
        $this->db->select("a.*,b.name");
        $this->db->from($this->_users_table." a");
        $this->db->where('status', 1);
        $this->db->join('ccs_roles b', 'a.role_id = b.id');
        $this->db->where('a.id !=', 9999); 
        $this->db->where('a.id !=', -1); 
        $this->db->limit($limit,$start);
        $this->db->order_by("a.".$sidx,$sord);
        $result = $this->db->get()->result(); 
        //die($this->db->last_query());
        return $result;
    }
    
    function getAllUsersCountNoRoot(){
        $this->db->from($this->_users_table);
        $this->db->where('status', 1);
        $this->db->where('id !=', 9999);
        $this->db->where('id !=', -1);
        $result = $this->db->count_all_results();  
        //die($this->db->last_query());
        return $result;
    }
    
    function getUserProfile($uid){
        $this->db->select("*");
        $this->db->from($this->_users_profile_table);
        $this->db->where('user_id', $uid);
        $result = $this->db->get()->result(); 
        //die($this->db->last_query());
        return $result;
    }
    
    function getAllUsersCount(){
        $this->db->from($this->_users_table);
        $this->db->where('status', 1);
        $this->db->where('id !=', 9999);
        $this->db->where('id !=', -1);
        $result = $this->db->count_all_results(); 
        //die($this->db->last_query());
        return $result;
    }
    
    function getUsersLevel($limit,$start,$sidx,$sord){
        $this->db->select("a.*,b.readonly");
        $this->db->from($this->_users_roles_table ." a");
        $this->db->join($this->_permissions_table .' b', 'a.id = b.role_id');
        $this->db->where('a.id !=', 0);
        $this->db->limit($limit,$start);
        $this->db->order_by($sidx,$sord);
        $result = $this->db->get()->result(); 
        //die($this->db->last_query());
        return $result;
    }    
    
    function getUsersLevelCount(){
        $this->db->from($this->_users_roles_table);
        $this->db->where('id !=', 0);
        $result = $this->db->count_all_results(); 
        //die($this->db->last_query());
        return $result;
    }
    
    
    function getUsersDivision($limit,$start,$sidx,$sord){
        $this->db->select("*");
        $this->db->from("ccs_division");
        //$this->db->where('role_id !=', 1);
        $this->db->limit($limit,$start);
        $this->db->order_by($sidx,$sord);
        $result = $this->db->get()->result(); 
        //die($this->db->last_query());
        return $result;
    }    
    
    function getUsersDivisionCount(){
        $this->db->from("ccs_division");
        //$this->db->where('role_id !=', 1);
        $result = $this->db->count_all_results(); 
        //die($this->db->last_query());
        return $result;
    }
    function idToRoles($role_id){
        $this->db->select("name as res");
        $this->db->from($this->_users_roles_table);
        $this->db->where('id', $role_id);
        $result = $this->db->get()->result(); 

        //die($this->db->last_query());
        if($this->db->count_all_results() > 0){
            return @$result[0]->res;
        } else {
            return "";
        }
        
    }
    
    function idToDivision($div_id){
        $this->db->select("div_name as res");
        $this->db->from('ccs_division');
        $this->db->where('id_div', $div_id);
        $result = $this->db->get()->result(); 
        
        if($this->db->count_all_results() > 0){
            return @$result[0]->res;
        } else {
            return "";
        }
        //die($this->db->last_query());
        
    }
    
    function getAdminRoles(){
        $this->db->from($this->_users_table);
        $this->db->where('status', 1);
        $this->db->where('role_id !=', LRID);
        $this->db->where('role_id =', LAID);
        $result = $this->db->count_all_results();
        //die($this->db->last_query());
        return $result;
    }
    
    function getRoles(){
        $this->db->select("*");
        $this->db->from($this->_users_roles_table);
        $this->db->where('id !=', 0);
        //$this->db->where('id !=', 1);
        $result = $this->db->get()->result(); 
        //die($this->db->last_query());
        return $result;
    }
    
    function getDivision(){
        $this->db->select("*");
        $this->db->from('ccs_division');
        $result = $this->db->get()->result(); 
        //die($this->db->last_query());
        return $result;
    }
    
    function getBranch(){
        $this->db->select("*");
        $this->db->from('ccs_branch');
        $result = $this->db->get()->result(); 
        //die($this->db->last_query());
        return $result;
    }
    
    function usernameToID($username){
        $this->db->select("id");
        $this->db->from($this->_users_table);
        $this->db->where('username', $username);
        $result = $this->db->get()->result(); 
        
        if($this->db->count_all_results() > 0){
            return @$result[0]->id;
        } else {
            return "";
        }
        //die($this->db->last_query());
        
    }
    
    function registerUser($data,$id){   
        $data['createdon'] = date('Y-m-d H:i:s', time());
        $this->db->where('user_id', $id);
		return $this->db->update($this->_users_profile_table, $data);
    }
    
    function blockUser($data,$id){   
        $data_profile = array(
               'updatedon' => date('Y-m-d H:i:s', time())
        );
        $data_user = array(
               'banned' => $data
        );

        $this->db->where('user_id', $id);        
        $this->db->update($this->_users_profile_table, $data_profile); 
        
        $this->db->where('id', $id);
        $this->db->update($this->_users_table, $data_user); 
        
		return true;
    }
    
    function deleteLevel($id_level)
	{
		$this->db->where('id', $id_level);
		$this->db->delete('ccs_roles');		
	}
    
    function deletePermission($id_permission)
	{
		$this->db->where('role_id', $id_permission);
		$this->db->delete('ccs_permissions');		
	}
    
    
    function readonlyLevel($data,$id){   

        $data_user = array(
               'readonly' => $data
        );
         
        $this->db->where('role_id', $id);
        $this->db->update($this->_permissions_table, $data_user); 
        
		return true;
    }
    
    function deleteUser($id){   
        $data_profile = array(
               'updatedon' => date('Y-m-d H:i:s', time())
        );
        $data_user = array(
               'status' => 0
        );
        
        if($id != AID){
            $this->db->where('user_id', $id);        
            $this->db->update($this->_users_profile_table, $data_profile); 
            
            $this->db->where('id', $id);
            $this->db->update($this->_users_table, $data_user);
            return true;
        } else {
            return false;
        }
         
        
		
    }
    
    function updateUser($data,$id){   
        $data['updatedon'] = date('Y-m-d H:i:s', time());
        $this->db->where('user_id', $id);
		$this->db->update($this->_users_profile_table, $data);
        
        $data_user = array(
               'role_id' => $data['levelID']
        );
        
        $this->db->where('id', $id);
        $this->db->update($this->_users_table, $data_user); 
        
		return true;
        
    }
    
   	function addDivision($name)
	{
  
		$data = array(
			'div_name' => $name,
            'div_Createdon' =>  date('Y-m-d H:i:s', time())
		);
            
		$this->db->insert("ccs_division", $data);
	}
    
   	function updateDivision($id_div,$name)
	{
		
        $data = array(
               'div_name' => $name,
               'div_Updatedon' =>  date('Y-m-d H:i:s', time())
        );
        $this->db->where('id_div', $id_div);
        return $this->db->update("ccs_division", $data); 		
	}
    
    function deleteDivision($id_div)
	{
		$this->db->where('id_div', $id_div);
		$this->db->delete('ccs_division');		
	}
    
    function checkField($table,$field,$value){
        
        $this->db->like($field, $value);
        $this->db->from($table);    
        return $this->db->count_all_results();
    }
    
    function updateMenuTree($data){
        $this->db->query("UPDATE ccs_menu set published = 0 where alias not in ($data)");
        $this->db->query("UPDATE ccs_menu set published = 1 where alias in ($data)");

        //die($this->db->last_query());
    }
    
    function publishMenu($data,$id){   
        $data_menu = array(
               'published_menutype' => $data
        );

        $this->db->where('id', $id);        
        $this->db->update('ccs_menu_types', $data_menu); 

        
		return true;
    }
    
    function getAllMenuLink(){
		$this->db->select("*");   
        $this->db->from('ccs_menu');      
        
        return $this->db->get()->result(); 

	}    
    
    function updatePermissionMenutype($data, $id){   
        $this->db->where('role_id', $id);
        
        $data_permission = array(
               'perm_menutype' => $data
        );
        return $this->db->update("ccs_permissions", $data_permission);
        
    }
    
    function getSession(){
        $this->db->where('ip_address', '127.0.0.1');
        $this->db->get('ccs_sessions');
        $row = $this->db->get('ccs_sessions')->result();
        var_export($row[0]->user_data);
    }
    
    function checkRoles($role_id){
        $this->db->from($this->_users_roles_table);
        $this->db->where('id !=', 0);
        $this->db->where('id', $role_id);
        
        $result = $this->db->count_all_results(); 
        //die($this->db->last_query());
        return $result;
    }
    
}